/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.ws_cleanup.RemoteCleaner;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

final class Wipeout
extends RemoteCleaner {
    private static final Wipeout INSTANCE = new Wipeout();
    private static final Command COMMAND = new Command();
    private static final Logger LOGGER = Logger.getLogger(Wipeout.class.getName());

    Wipeout() {
    }

    static Wipeout getInstance() {
        return INSTANCE;
    }

    @Override
    protected void perform(FilePath workspace) throws IOException, InterruptedException {
        FilePath deleteMe = workspace.withSuffix("_ws-cleanup_" + System.currentTimeMillis());
        workspace.renameTo(deleteMe);
        if (!deleteMe.exists()) {
            LOGGER.log(Level.WARNING, "Cleaning workspace synchronously. Failed to rename {0} to {1}.", new Object[]{workspace.getRemote(), deleteMe.getName()});
            workspace.deleteRecursive();
        }
        deleteMe.actAsync((FilePath.FileCallable)COMMAND);
    }

    private static final class Command
    implements FilePath.FileCallable<Void> {
        private Command() {
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try {
                Util.deleteRecursive((File)f);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Unable to delete workspace", ex);
            }
            if (f.exists()) {
                LOGGER.log(Level.SEVERE, "Workspace not deleted successfully: " + f.getAbsolutePath());
            }
            return null;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            checker.check((RoleSensitive)this, Roles.SLAVE);
        }
    }
}

