/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.operations;

import com.chikli.hudson.plugin.naginator.FixedDelay;
import com.chikli.hudson.plugin.naginator.NaginatorScheduleAction;
import com.chikli.hudson.plugin.naginator.ScheduleDelay;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.operations.AbortOperation;
import hudson.plugins.build_timeout.operations.Messages;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbortAndRestartOperation
extends BuildTimeOutOperation {
    private final String maxRestarts;
    private static final Logger log = Logger.getLogger(AbortAndRestartOperation.class.getName());

    public String getMaxRestarts() {
        return this.maxRestarts;
    }

    @DataBoundConstructor
    public AbortAndRestartOperation(String maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    private static boolean isPresent() {
        try {
            Class.forName("com.chikli.hudson.plugin.naginator.NaginatorScheduleAction");
            return true;
        }
        catch (ClassNotFoundException ex) {
            log.log(Level.FINEST, "Naginator not available. ", ex);
            return false;
        }
    }

    private void rescheduleBuild(AbstractBuild<?, ?> build, BuildListener listener) {
        FixedDelay sd = new FixedDelay(0);
        String maxRestartsStr = null;
        try {
            maxRestartsStr = build.getEnvironment((TaskListener)listener).expand(this.maxRestarts);
        }
        catch (IOException e1) {
            listener.error("Failed to expand environment variables.");
            e1.printStackTrace(listener.getLogger());
            return;
        }
        catch (InterruptedException e1) {
            listener.error("Failed to expand environment variables.");
            e1.printStackTrace(listener.getLogger());
            return;
        }
        int maxRestarts = 0;
        try {
            maxRestarts = Integer.parseInt(maxRestartsStr);
        }
        catch (NumberFormatException e) {
            listener.error("Invalid Maximum restarts: {0}", new Object[]{maxRestartsStr});
            e.printStackTrace(listener.getLogger());
            return;
        }
        build.addAction((Action)new NaginatorScheduleAction(maxRestarts, (ScheduleDelay)sd, false));
        listener.getLogger().println(Messages.AbortAndRestartOperation_ScheduledRestart(maxRestarts));
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, BuildListener listener, long effectiveTimeout) {
        if (AbortAndRestartOperation.isPresent()) {
            this.rescheduleBuild(build, listener);
        } else {
            listener.error(Messages.AbortAndRestartOperation_InstallNaginator());
        }
        return new AbortOperation().perform(build, listener, effectiveTimeout);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class DescriptorImpl
    extends BuildTimeOutOperationDescriptor {
        public String getDisplayName() {
            return Messages.AbortAndRestartOperation_DisplayName();
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject<?, ?>> jobType) {
            return AbortAndRestartOperation.isPresent();
        }
    }
}

