/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject.service;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectActionRetriever {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectActionRetriever.class.getName());

    public Action getEnvInjectAction(AbstractBuild<?, ?> build) {
        if (build == null) {
            throw new NullPointerException("A build object must be set.");
        }
        try {
            Method method;
            Object object;
            Class<?> matrixClass = Class.forName("hudson.matrix.MatrixRun");
            if (matrixClass.isInstance(build) && (object = (method = matrixClass.getMethod("getParentBuild", null)).invoke(build, new Object[0])) instanceof AbstractBuild) {
                build = (AbstractBuild)object;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINEST, String.format("hudson.matrix.MatrixRun is not installed", e));
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.WARNING, String.format("The method getParentBuild does not exist for hudson.matrix.MatrixRun", e));
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.WARNING, String.format("There was a problem in the invocation of getParentBuild in hudson.matrix.MatrixRun", e));
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.WARNING, String.format("There was a problem in the invocation of getParentBuild in hudson.matrix.MatrixRun", e));
        }
        List actions = build.getActions();
        for (Action action : actions) {
            if (action == null || !"injectedEnvVars".equals(action.getUrlName())) continue;
            return action;
        }
        return null;
    }
}

