/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.service.EnvInjectSavable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectAction
implements Action,
StaplerProxy {
    public static final String URL_NAME = "injectedEnvVars";
    @CheckForNull
    protected transient Map<String, String> envMap;
    @Nonnull
    private AbstractBuild build;
    private transient Map<String, String> resultVariables;
    private transient File rootDir;
    @CheckForNull
    private transient Set<String> sensibleVariables;

    public EnvInjectAction(@Nonnull AbstractBuild build, @CheckForNull Map<String, String> envMap) {
        this.build = build;
        this.envMap = envMap;
    }

    public void overrideAll(Map<String, String> all) {
        this.overrideAll(Collections.<String>emptySet(), all);
    }

    public void overrideAll(@CheckForNull Set<String> sensibleVariables, @CheckForNull Map<String, String> all) {
        if (this.envMap == null) {
            return;
        }
        if (all == null) {
            return;
        }
        this.sensibleVariables = sensibleVariables;
        this.envMap.putAll(all);
    }

    public Map<String, String> getEnvMap() {
        if (this.envMap == null) {
            try {
                Map<String, String> result = this.getEnvironment(this.build);
                return result == null ? null : UnmodifiableMap.decorate(result);
            }
            catch (EnvInjectException e) {
                return null;
            }
        }
        return UnmodifiableMap.decorate(this.envMap);
    }

    public String getIconFileName() {
        return "document-properties.gif";
    }

    public String getDisplayName() {
        return "Environment Variables";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            EnvInjectSavable dao = new EnvInjectSavable();
            if (this.rootDir == null) {
                dao.saveEnvironment(this.build.getRootDir(), Maps.transformEntries(this.envMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

                    public String transformEntry(String key, String value) {
                        return EnvInjectAction.this.sensibleVariables != null && EnvInjectAction.this.sensibleVariables.contains(key) ? "********" : value;
                    }
                }));
                return this;
            }
            dao.saveEnvironment(this.rootDir, this.envMap);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this;
    }

    private Map<String, String> getEnvironment(@CheckForNull AbstractBuild build) throws EnvInjectException {
        if (build == null) {
            return null;
        }
        AbstractProject project = build.getProject();
        if (project == null) {
            return null;
        }
        EnvInjectSavable dao = new EnvInjectSavable();
        return dao.getEnvironment(build.getRootDir());
    }

    public Run<?, ?> getOwner() {
        return this.build;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.resultVariables != null) {
            this.envMap = this.resultVariables;
            return this;
        }
        Map<String, String> resultMap = null;
        try {
            if (this.build != null) {
                resultMap = this.getEnvironment(this.build);
            } else if (this.rootDir != null) {
                EnvInjectSavable dao = new EnvInjectSavable();
                resultMap = dao.getEnvironment(this.rootDir);
            }
            if (resultMap != null) {
                this.envMap = resultMap;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this;
    }

    public Object getTarget() {
        throw new UnsupportedOperationException();
    }

    @CheckForNull
    public Set<String> getSensibleVariables() {
        return this.sensibleVariables;
    }
}

