/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SidACL;
import hudson.util.RobustReflectionConverter;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.matrixauth.Messages;

public class ProjectMatrixAuthorizationStrategy
extends GlobalMatrixAuthorizationStrategy {
    @Extension
    public static final Descriptor<AuthorizationStrategy> DESCRIPTOR = new GlobalMatrixAuthorizationStrategy.DescriptorImpl(){

        @Override
        protected GlobalMatrixAuthorizationStrategy create() {
            return new ProjectMatrixAuthorizationStrategy();
        }

        @Override
        public String getDisplayName() {
            return Messages.ProjectMatrixAuthorizationStrategy_DisplayName();
        }
    };

    public ACL getACL(Job<?, ?> project) {
        AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)project.getProperty(AuthorizationMatrixProperty.class);
        if (amp != null) {
            SidACL projectAcl = amp.getACL();
            if (!amp.isBlocksInheritance()) {
                ACL parentAcl = this.getACL(project.getParent());
                return ProjectMatrixAuthorizationStrategy.inheritingACL(parentAcl, (ACL)projectAcl);
            }
            return projectAcl;
        }
        return this.getACL(project.getParent());
    }

    private static ACL inheritingACL(final ACL parent, final ACL child) {
        if (parent instanceof SidACL && child instanceof SidACL) {
            return ((SidACL)child).newInheritingACL((SidACL)parent);
        }
        return new ACL(){

            public boolean hasPermission(Authentication a, Permission permission) {
                return child.hasPermission(a, permission) || parent.hasPermission(a, permission);
            }
        };
    }

    public ACL getACL(ItemGroup g) {
        if (g instanceof Item) {
            Item item = (Item)g;
            return item.getACL();
        }
        return this.getRootACL();
    }

    public ACL getACL(AbstractItem item) {
        com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty p;
        if (Jenkins.getActiveInstance().getPlugin("cloudbees-folder") != null && item instanceof AbstractFolder && (p = (com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty)((AbstractFolder)item).getProperties().get(com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty.class)) != null) {
            return ProjectMatrixAuthorizationStrategy.inheritingACL(this.getACL(item.getParent()), (ACL)p.getACL());
        }
        return this.getACL(item.getParent());
    }

    @Override
    public Set<String> getGroups() {
        HashSet<String> r = new HashSet<String>();
        r.addAll(super.getGroups());
        for (Job j : Jenkins.getActiveInstance().getItems(Job.class)) {
            AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)j.getProperty(AuthorizationMatrixProperty.class);
            if (amp == null) continue;
            r.addAll(amp.getGroups());
        }
        return r;
    }

    public static class ConverterImpl
    extends GlobalMatrixAuthorizationStrategy.ConverterImpl {
        private RobustReflectionConverter ref;

        public ConverterImpl(Mapper m) {
            this.ref = new RobustReflectionConverter(m, new JVM().bestReflectionProvider());
        }

        @Override
        protected GlobalMatrixAuthorizationStrategy create() {
            return new ProjectMatrixAuthorizationStrategy();
        }

        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String name = reader.peekNextChild();
            if (name != null && (name.equals("permission") || name.equals("useProjectSecurity"))) {
                return super.unmarshal(reader, context);
            }
            return this.ref.unmarshal(reader, context);
        }

        @Override
        public boolean canConvert(Class type) {
            return type == ProjectMatrixAuthorizationStrategy.class;
        }
    }
}

