/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.security.AccessControlled;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import hudson.util.RobustReflectionConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.Sid;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AuthorizationMatrixProperty
extends JobProperty<Job<?, ?>> {
    private transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
    private Set<String> sids = new HashSet<String>();
    private boolean blocksInheritance = false;

    private AuthorizationMatrixProperty() {
    }

    public AuthorizationMatrixProperty(Map<Permission, Set<String>> grantedPermissions) {
        for (Map.Entry<Permission, Set<String>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), new HashSet(e.getValue()));
        }
    }

    public Set<String> getGroups() {
        return this.sids;
    }

    public List<String> getAllSIDs() {
        HashSet<String> r = new HashSet<String>();
        for (Set<String> set : this.grantedPermissions.values()) {
            r.addAll(set);
        }
        r.remove("anonymous");
        Object[] data = r.toArray(new String[r.size()]);
        Arrays.sort(data);
        return Arrays.asList(data);
    }

    public Map<Permission, Set<String>> getGrantedPermissions() {
        return Collections.unmodifiableMap(this.grantedPermissions);
    }

    protected void add(Permission p, String sid) {
        Set<String> set = this.grantedPermissions.get(p);
        if (set == null) {
            set = new HashSet<String>();
            this.grantedPermissions.put(p, set);
        }
        set.add(sid);
        this.sids.add(sid);
    }

    public SidACL getACL() {
        return this.acl;
    }

    private void setBlocksInheritance(boolean blocksInheritance) {
        this.blocksInheritance = blocksInheritance;
    }

    public boolean isBlocksInheritance() {
        return this.blocksInheritance;
    }

    public boolean hasPermission(String sid, Permission p) {
        while (p != null) {
            Set<String> set = this.grantedPermissions.get(p);
            if (set != null && set.contains(sid)) {
                return true;
            }
            p = p.impliedBy;
        }
        return false;
    }

    public boolean hasExplicitPermission(String sid, Permission p) {
        Set<String> set = this.grantedPermissions.get(p);
        return set != null && set.contains(sid);
    }

    private void add(String shortForm) {
        int idx = shortForm.indexOf(58);
        Permission p = Permission.fromId((String)shortForm.substring(0, idx));
        if (p == null) {
            throw new IllegalArgumentException("Failed to parse '" + shortForm + "' --- no such permission");
        }
        this.add(p, shortForm.substring(idx + 1));
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixProperty.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)((Object)source);
            if (amp.isBlocksInheritance()) {
                writer.startNode("blocksInheritance");
                writer.setValue("true");
                writer.endNode();
            }
            for (Map.Entry e : amp.grantedPermissions.entrySet()) {
                String p = ((Permission)e.getKey()).getId();
                for (String sid : (Set)e.getValue()) {
                    writer.startNode("permission");
                    writer.setValue(p + ':' + sid);
                    writer.endNode();
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            AuthorizationMatrixProperty as = new AuthorizationMatrixProperty();
            String prop = reader.peekNextChild();
            if (prop != null && prop.equals("useProjectSecurity")) {
                reader.moveDown();
                reader.getValue();
                reader.moveUp();
                prop = reader.peekNextChild();
            }
            if ("blocksInheritance".equals(prop)) {
                reader.moveDown();
                as.setBlocksInheritance("true".equals(reader.getValue()));
                reader.moveUp();
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                try {
                    as.add(reader.getValue());
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(AuthorizationMatrixProperty.class.getName()).log(Level.WARNING, "Skipping a non-existent permission", ex);
                    RobustReflectionConverter.addErrorInContext((UnmarshallingContext)context, (Throwable)ex);
                }
                reader.moveUp();
            }
            if (GlobalMatrixAuthorizationStrategy.migrateHudson2324(as.grantedPermissions)) {
                OldDataMonitor.report((UnmarshallingContext)context, (String)"1.301");
            }
            return as;
        }
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As designed, implements a third state for the ternary logic")
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixProperty.this.hasPermission(this.toString(sid), p)) {
                return true;
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if ((formData = formData.getJSONObject("useProjectSecurity")).isNullObject()) {
                return null;
            }
            AuthorizationMatrixProperty amp = new AuthorizationMatrixProperty();
            amp.setBlocksInheritance(!formData.getJSONObject("blocksInheritance").isNullObject());
            JSONObject data = formData.getJSONObject("data");
            for (Map.Entry r : data.entrySet()) {
                String sid = (String)r.getKey();
                if (!(r.getValue() instanceof JSONObject)) {
                    throw new Descriptor.FormException("not an object: " + formData, "data");
                }
                JSONObject value = (JSONObject)r.getValue();
                for (Map.Entry e : value.entrySet()) {
                    if (!(e.getValue() instanceof Boolean)) {
                        throw new Descriptor.FormException("not a boolean: " + formData, "data");
                    }
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    amp.add(p, sid);
                }
            }
            return amp;
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Jenkins.getActiveInstance().getAuthorizationStrategy() instanceof ProjectMatrixAuthorizationStrategy;
        }

        public String getDisplayName() {
            return "Authorization Matrix";
        }

        public List<PermissionGroup> getAllGroups() {
            ArrayList<PermissionGroup> r = new ArrayList<PermissionGroup>();
            for (PermissionGroup pg : PermissionGroup.getAll()) {
                if (!pg.hasPermissionContainedBy(PermissionScope.ITEM)) continue;
                r.add(pg);
            }
            return r;
        }

        public boolean showPermission(Permission p) {
            return p.getEnabled() && p.isContainedBy(PermissionScope.ITEM);
        }

        public FormValidation doCheckName(@AncestorInPath Job project, @QueryParameter String value) throws IOException, ServletException {
            return GlobalMatrixAuthorizationStrategy.DESCRIPTOR.doCheckName_(value, (AccessControlled)project, Item.CONFIGURE);
        }
    }
}

