/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl.util.introspection.ClassMap;
import org.apache.commons.jexl.util.introspection.MethodMap;
import org.apache.commons.logging.Log;

public class IntrospectorBase {
    private final Log rlog;
    protected final Map classMethodMaps = new HashMap();
    private Set cachedClassNames = new HashSet();

    public IntrospectorBase(Log rlog) {
        this.rlog = rlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class c, String name, Object[] params) throws IllegalArgumentException, MethodMap.AmbiguousException {
        ClassMap classMap;
        if (c == null) {
            throw new IllegalArgumentException("Introspector.getMethod(): Class method key was null: " + name);
        }
        if (params == null) {
            throw new IllegalArgumentException("params object is null!");
        }
        Map map = this.classMethodMaps;
        synchronized (map) {
            classMap = (ClassMap)this.classMethodMaps.get(c);
            if (classMap == null) {
                if (this.cachedClassNames.contains(c.getName())) {
                    this.clearCache();
                }
                classMap = this.createClassMap(c);
            }
        }
        return classMap.findMethod(name, params);
    }

    protected ClassMap createClassMap(Class c) {
        ClassMap classMap = new ClassMap(c, this.rlog);
        this.classMethodMaps.put(c, classMap);
        this.cachedClassNames.add(c.getName());
        return classMap;
    }

    protected void clearCache() {
        this.classMethodMaps.clear();
        this.cachedClassNames = new HashSet();
    }
}

