/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.WorkspaceList;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.WorkspaceStep;

public class WorkspaceStepExecution
extends AbstractStepExecutionImpl {
    @Inject(optional=true)
    private transient WorkspaceStep step;
    @StepContextParameter
    private transient Computer computer;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FlowNode flowNode;
    private BodyExecution body;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        WorkspaceList.Lease lease;
        Job job = this.run.getParent();
        if (!(job instanceof TopLevelItem)) {
            throw new Exception(job + " must be a top-level job");
        }
        Node node = this.computer.getNode();
        if (node == null) {
            throw new Exception("computer does not correspond to a live node");
        }
        String dir = this.step.getDir();
        if (dir == null) {
            FilePath baseWorkspace = node.getWorkspaceFor((TopLevelItem)job);
            if (baseWorkspace == null) {
                throw new IllegalStateException(node + " is offline");
            }
            lease = this.computer.getWorkspaceList().allocate(baseWorkspace);
        } else {
            FilePath rootPath = node.getRootPath();
            if (rootPath == null) {
                throw new IllegalStateException(node + " is offline");
            }
            FilePath baseWorkspace = rootPath.child(dir);
            lease = this.computer.getWorkspaceList().allocate(baseWorkspace);
        }
        FilePath workspace = lease.path;
        this.flowNode.addAction((Action)new WorkspaceActionImpl(workspace, this.flowNode));
        this.listener.getLogger().println("Running in " + workspace);
        this.body = this.getContext().newBodyInvoker().withContext((Object)workspace).withCallback((BodyExecutionCallback)new Callback(lease)).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="lease is pickled")
    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private final WorkspaceList.Lease lease;

        Callback(WorkspaceList.Lease lease) {
            this.lease = lease;
        }

        protected void finished(StepContext context) throws Exception {
            this.lease.release();
        }
    }
}

