/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueListener;
import hudson.model.queue.SubTask;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.RequestAbortedException;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.util.Timer;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;
import org.jenkinsci.plugins.durabletask.executors.ContinuedTask;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.steps.durable_task.Messages;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.ExportedBean;

public class ExecutorStepExecution
extends AbstractStepExecutionImpl {
    @Inject(optional=true)
    private ExecutorStep step;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient FlowExecution flowExecution;
    @StepContextParameter
    private transient FlowNode flowNode;
    private static final String COOKIE_VAR = "JENKINS_SERVER_COOKIE";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ExecutorStepExecution.class.getName());

    public boolean start() throws Exception {
        final PlaceholderTask task = new PlaceholderTask(this.getContext(), this.step.getLabel(), this.run);
        if (Queue.getInstance().schedule2((Queue.Task)task, 0, new Action[0]).getCreateItem() == null) {
            throw new IllegalStateException("failed to schedule task");
        }
        Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                Queue.Item item = Queue.getInstance().getItem((Queue.Task)task);
                if (item != null) {
                    PrintStream logger;
                    try {
                        logger = ExecutorStepExecution.this.listener.getLogger();
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                        return;
                    }
                    logger.println("Still waiting to schedule task");
                    String why = item.getWhy();
                    if (why != null) {
                        logger.println(why);
                    }
                }
            }
        }, 15L, TimeUnit.SECONDS);
        return false;
    }

    public void stop(Throwable cause) {
        Jenkins j;
        for (Queue.Item item : Queue.getInstance().getItems()) {
            if (!(item.task instanceof PlaceholderTask) || !((PlaceholderTask)item.task).context.equals((Object)this.getContext())) continue;
            Queue.getInstance().cancel(item);
            break;
        }
        if ((j = Jenkins.getInstance()) != null) {
            block1: for (Computer c : j.getComputers()) {
                for (Executor e : c.getExecutors()) {
                    Queue.Executable exec = e.getCurrentExecutable();
                    if (!(exec instanceof PlaceholderTask.PlaceholderExecutable) || !((PlaceholderTask.PlaceholderExecutable)exec).getParent().context.equals((Object)this.getContext())) continue;
                    PlaceholderTask.finish(((PlaceholderTask.PlaceholderExecutable)exec).getParent().cookie);
                    break block1;
                }
            }
        }
        this.getContext().onFailure(cause);
    }

    public void onResume() {
        super.onResume();
        for (Queue.Item item : Queue.getInstance().getItems()) {
            if (!(item.task instanceof PlaceholderTask) || !((PlaceholderTask)item.task).context.equals((Object)this.getContext())) continue;
            LOGGER.log(Level.FINE, "Queue item for node block in {0} is still waiting after reload", this.run);
            return;
        }
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            for (Computer c : j.getComputers()) {
                for (Executor e : c.getExecutors()) {
                    Queue.Executable exec = e.getCurrentExecutable();
                    if (!(exec instanceof PlaceholderTask.PlaceholderExecutable) || !((PlaceholderTask.PlaceholderExecutable)exec).getParent().context.equals((Object)this.getContext())) continue;
                    LOGGER.log(Level.FINE, "Node block in {0} is running on {1} after reload", new Object[]{this.run, c.getName()});
                    return;
                }
            }
        }
        if (this.step == null) {
            this.listener.getLogger().println("Queue item for node block in " + this.run.getFullDisplayName() + " is missing (perhaps JENKINS-34281), but cannot reschedule");
            return;
        }
        this.listener.getLogger().println("Queue item for node block in " + this.run.getFullDisplayName() + " is missing (perhaps JENKINS-34281); rescheduling");
        try {
            this.start();
        }
        catch (Exception x) {
            this.getContext().onFailure((Throwable)x);
        }
    }

    public String getStatus() {
        for (Queue.Item item : Queue.getInstance().getItems()) {
            if (!(item.task instanceof PlaceholderTask) || !((PlaceholderTask)item.task).context.equals((Object)this.getContext())) continue;
            return "waiting for " + item.task.getFullDisplayName() + " to be scheduled; blocked: " + item.getWhy();
        }
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            for (Computer c : j.getComputers()) {
                for (Executor e : c.getExecutors()) {
                    Queue.Executable exec = e.getCurrentExecutable();
                    if (!(exec instanceof PlaceholderTask.PlaceholderExecutable) || !((PlaceholderTask.PlaceholderExecutable)exec).getParent().context.equals((Object)this.getContext())) continue;
                    return "running on " + c.getName();
                }
            }
        }
        return "node block appears to be neither running nor scheduled";
    }

    @ExportedBean
    public static final class PlaceholderTask
    implements ContinuedTask,
    Serializable,
    AccessControlled {
        private static final Map<String, RunningTask> runningTasks = new HashMap<String, RunningTask>();
        private final StepContext context;
        private String label;
        private String runId;
        private String cookie;

        PlaceholderTask(StepContext context, String label, Run<?, ?> run) {
            this.context = context;
            this.label = label;
            this.runId = run.getExternalizableId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readResolve() {
            LOGGER.log(Level.FINE, "deserialized {0}", this.cookie);
            if (this.cookie != null) {
                Map<String, RunningTask> map = runningTasks;
                synchronized (map) {
                    runningTasks.put(this.cookie, new RunningTask());
                }
            }
            return this;
        }

        public Queue.Executable createExecutable() throws IOException {
            return new PlaceholderExecutable();
        }

        public Label getAssignedLabel() {
            if (this.label == null) {
                return null;
            }
            if (this.label.isEmpty()) {
                Jenkins j = Jenkins.getInstance();
                if (j == null) {
                    return null;
                }
                return j.getSelfLabel();
            }
            return Label.get((String)this.label);
        }

        public Node getLastBuiltOn() {
            if (this.label == null) {
                return null;
            }
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return null;
            }
            return j.getNode(this.label);
        }

        public boolean isBuildBlocked() {
            return false;
        }

        @Deprecated
        public String getWhyBlocked() {
            return null;
        }

        public CauseOfBlockage getCauseOfBlockage() {
            return null;
        }

        public boolean isConcurrentBuild() {
            return false;
        }

        public Collection<? extends SubTask> getSubTasks() {
            return Collections.singleton(this);
        }

        public Queue.Task getOwnerTask() {
            Run<?, ?> r = this.run();
            if (r != null && r.getParent() instanceof Queue.Task) {
                return (Queue.Task)r.getParent();
            }
            return this;
        }

        public Object getSameNodeConstraint() {
            return null;
        }

        public ACL getACL() {
            try {
                if (!this.context.isReady()) {
                    return Jenkins.getActiveInstance().getACL();
                }
                FlowExecution exec = (FlowExecution)this.context.get(FlowExecution.class);
                if (exec == null) {
                    return Jenkins.getActiveInstance().getACL();
                }
                Queue.Executable executable = exec.getOwner().getExecutable();
                if (executable instanceof AccessControlled) {
                    return ((AccessControlled)executable).getACL();
                }
                return Jenkins.getActiveInstance().getACL();
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
                return Jenkins.getActiveInstance().getACL();
            }
        }

        public void checkPermission(Permission p) throws AccessDeniedException {
            this.getACL().checkPermission(p);
        }

        public boolean hasPermission(Permission p) {
            return this.getACL().hasPermission(p);
        }

        public void checkAbortPermission() {
            this.checkPermission(Item.CANCEL);
        }

        public boolean hasAbortPermission() {
            return this.hasPermission(Item.CANCEL);
        }

        @CheckForNull
        public Run<?, ?> run() {
            try {
                if (!this.context.isReady()) {
                    return null;
                }
                return (Run)this.context.get(Run.class);
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "broken " + this.cookie, x);
                PlaceholderTask.finish(this.cookie);
                return null;
            }
        }

        @CheckForNull
        public Run<?, ?> runForDisplay() {
            Run<?, ?> r = this.run();
            if (r == null && this.runId != null) {
                return Run.fromExternalizableId((String)this.runId);
            }
            return r;
        }

        public String getUrl() {
            Run<?, ?> r = this.runForDisplay();
            return r != null ? r.getUrl() : "";
        }

        public String getDisplayName() {
            Run<?, ?> r = this.runForDisplay();
            return r != null ? Messages.ExecutorStepExecution_PlaceholderTask_displayName(r.getFullDisplayName()) : Messages.ExecutorStepExecution_PlaceholderTask_displayName_unknown();
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getFullDisplayName() {
            return this.getDisplayName();
        }

        public long getEstimatedDuration() {
            Run<?, ?> r = this.run();
            return r != null ? r.getEstimatedDuration() : -1L;
        }

        public ResourceList getResourceList() {
            return new ResourceList();
        }

        public Authentication getDefaultAuthentication() {
            return ACL.SYSTEM;
        }

        public Authentication getDefaultAuthentication(Queue.Item item) {
            return this.getDefaultAuthentication();
        }

        public boolean isContinued() {
            return this.cookie != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void finish(final @CheckForNull String cookie) {
            if (cookie == null) {
                return;
            }
            Map<String, RunningTask> map = runningTasks;
            synchronized (map) {
                final RunningTask runningTask = runningTasks.remove(cookie);
                if (runningTask == null) {
                    LOGGER.log(Level.FINE, "no running task corresponds to {0}", cookie);
                    return;
                }
                final AsynchronousExecution execution = runningTask.execution;
                if (execution == null) {
                    return;
                }
                assert (runningTask.launcher != null);
                Timer.get().submit(new Runnable(){

                    @Override
                    public void run() {
                        execution.completed(null);
                        try {
                            runningTask.launcher.kill(Collections.singletonMap(ExecutorStepExecution.COOKIE_VAR, cookie));
                        }
                        catch (ChannelClosedException channelClosedException) {
                        }
                        catch (RequestAbortedException requestAbortedException) {
                        }
                        catch (Exception x) {
                            LOGGER.log(Level.WARNING, "failed to shut down " + cookie, x);
                        }
                    }
                });
            }
        }

        @ExportedBean
        private final class PlaceholderExecutable
        implements ContinuableExecutable {
            private static final long serialVersionUID = 1L;

            private PlaceholderExecutable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Run r;
                Launcher launcher;
                TaskListener listener;
                block18: {
                    try {
                        Executor exec = Executor.currentExecutor();
                        if (exec == null) {
                            throw new IllegalStateException("running task without associated executor thread");
                        }
                        Computer computer = exec.getOwner();
                        Node node = computer.getNode();
                        if (node == null) {
                            throw new IllegalStateException("running computer lacks a node");
                        }
                        listener = (TaskListener)PlaceholderTask.this.context.get(TaskListener.class);
                        launcher = node.createLauncher(listener);
                        r = (Run)PlaceholderTask.this.context.get(Run.class);
                        if (PlaceholderTask.this.cookie == null) {
                            PlaceholderTask.this.cookie = UUID.randomUUID().toString();
                            PlaceholderTask.this.label = computer.getName();
                            EnvVars env = computer.getEnvironment();
                            env.overrideAll((Map)computer.buildEnvironment(listener));
                            env.put(ExecutorStepExecution.COOKIE_VAR, PlaceholderTask.this.cookie);
                            if (exec.getOwner() instanceof Jenkins.MasterComputer) {
                                env.put("NODE_NAME", "master");
                            } else {
                                env.put("NODE_NAME", PlaceholderTask.this.label);
                            }
                            env.put("EXECUTOR_NUMBER", String.valueOf(exec.getNumber()));
                            env.put("NODE_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
                            Map map = runningTasks;
                            synchronized (map) {
                                runningTasks.put(PlaceholderTask.this.cookie, new RunningTask());
                            }
                            Job j = r.getParent();
                            if (!(j instanceof TopLevelItem)) {
                                throw new Exception(j + " must be a top-level job");
                            }
                            FilePath p = node.getWorkspaceFor((TopLevelItem)j);
                            if (p == null) {
                                throw new IllegalStateException(node + " is offline");
                            }
                            WorkspaceList.Lease lease = computer.getWorkspaceList().allocate(p);
                            FilePath workspace = lease.path;
                            env.put("WORKSPACE", workspace.getRemote());
                            FlowNode flowNode = (FlowNode)PlaceholderTask.this.context.get(FlowNode.class);
                            flowNode.addAction((Action)new WorkspaceActionImpl(workspace, flowNode));
                            listener.getLogger().println("Running on " + computer.getDisplayName() + " in " + workspace);
                            PlaceholderTask.this.context.newBodyInvoker().withContexts(new Object[]{exec, computer, env, workspace}).withCallback((BodyExecutionCallback)new Callback(PlaceholderTask.this.cookie, lease)).start();
                            LOGGER.log(Level.FINE, "started {0}", PlaceholderTask.this.cookie);
                            break block18;
                        }
                        LOGGER.log(Level.FINE, "resuming {0}", PlaceholderTask.this.cookie);
                    }
                    catch (Exception x) {
                        PlaceholderTask.this.context.onFailure((Throwable)x);
                        return;
                    }
                }
                Map map = runningTasks;
                synchronized (map) {
                    LOGGER.log(Level.FINE, "waiting on {0}", PlaceholderTask.this.cookie);
                    RunningTask runningTask = (RunningTask)runningTasks.get(PlaceholderTask.this.cookie);
                    if (runningTask == null) {
                        LOGGER.log(Level.FINE, "running task apparently finished quickly for {0}", PlaceholderTask.this.cookie);
                        return;
                    }
                    assert (runningTask.execution == null);
                    assert (runningTask.launcher == null);
                    runningTask.launcher = launcher;
                    runningTask.execution = new AsynchronousExecution(){

                        public void interrupt(boolean forShutdown) {
                            if (forShutdown) {
                                return;
                            }
                            LOGGER.log(Level.FINE, "interrupted {0}", PlaceholderTask.this.cookie);
                            Executor masterExecutor = r.getExecutor();
                            if (masterExecutor != null) {
                                masterExecutor.interrupt();
                            } else {
                                super.getExecutor().recordCauseOfInterruption(r, listener);
                                this.completed(null);
                            }
                        }

                        public boolean blocksRestart() {
                            return false;
                        }

                        public boolean displayCell() {
                            return true;
                        }
                    };
                    throw runningTask.execution;
                }
            }

            public PlaceholderTask getParent() {
                return PlaceholderTask.this;
            }

            public long getEstimatedDuration() {
                return this.getParent().getEstimatedDuration();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean willContinue() {
                Map map = runningTasks;
                synchronized (map) {
                    return runningTasks.containsKey(PlaceholderTask.this.cookie);
                }
            }

            @CheckForNull
            @Restricted(value={DoNotUse.class})
            public Executor getExecutor() {
                return Executor.of((Queue.Executable)this);
            }

            @Restricted(value={NoExternalUse.class})
            public String getUrl() {
                return PlaceholderTask.this.getUrl();
            }

            public String toString() {
                return "PlaceholderExecutable:" + this.getUrl() + ":" + PlaceholderTask.this.cookie;
            }
        }

        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="lease is pickled")
        private static final class Callback
        extends BodyExecutionCallback.TailCall {
            private final String cookie;
            private WorkspaceList.Lease lease;

            Callback(String cookie, WorkspaceList.Lease lease) {
                this.cookie = cookie;
                this.lease = lease;
            }

            protected void finished(StepContext context) throws Exception {
                LOGGER.log(Level.FINE, "finished {0}", this.cookie);
                this.lease.release();
                this.lease = null;
                PlaceholderTask.finish(this.cookie);
            }
        }
    }

    private static final class RunningTask {
        @Nullable
        AsynchronousExecution execution;
        @Nullable
        Launcher launcher;

        private RunningTask() {
        }
    }

    @Extension
    public static class CancelledItemListener
    extends QueueListener {
        public void onLeft(Queue.LeftItem li) {
            if (li.isCancelled() && li.task instanceof PlaceholderTask) {
                ((PlaceholderTask)li.task).context.onFailure((Throwable)new AbortException(Messages.ExecutorStepExecution_queue_task_cancelled()));
            }
        }
    }
}

