/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class ExecutorStep
extends AbstractStepImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final String label;

    @DataBoundConstructor
    public ExecutorStep(String label) {
        this.label = Util.fixEmptyAndTrim((String)label);
    }

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ExecutorStepExecution.class);
        }

        public String getFunctionName() {
            return "node";
        }

        public String getDisplayName() {
            return "Allocate node";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public AutoCompletionCandidates doAutoCompleteLabel(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            Jenkins j = Jenkins.getInstance();
            if (j != null) {
                for (Label label : j.getLabels()) {
                    if (!label.getName().startsWith(value)) continue;
                    c.add(label.getName());
                }
            }
            return c;
        }

        public FormValidation doCheckLabel(@QueryParameter String value) {
            return AbstractProject.AbstractProjectDescriptor.validateLabelExpression((String)value, null);
        }

        public Set<Class<?>> getProvidedContext() {
            return ImmutableSet.of(Executor.class, Computer.class, FilePath.class, EnvVars.class, Node.class, Launcher.class, (Object[])new Class[0]);
        }
    }
}

