/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.Extension;
import hudson.FilePath;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.TryRepeatedly;

public class FilePathPickle
extends Pickle {
    private final String slave;
    private final String path;

    private FilePathPickle(FilePath v) {
        this.slave = FilePathUtils.getNodeName((FilePath)v);
        this.path = v.getRemote();
    }

    public ListenableFuture<FilePath> rehydrate(FlowExecutionOwner owner) {
        return new TryRepeatedly<FilePath>(1){

            protected FilePath tryResolve() {
                return FilePathUtils.find((String)FilePathPickle.this.slave, (String)FilePathPickle.this.path);
            }

            public String toString() {
                return "Looking for path named \u2018" + FilePathPickle.this.path + "\u2019 on computer named \u2018" + FilePathPickle.this.slave + "\u2019";
            }
        };
    }

    @Extension
    public static final class Factory
    extends SingleTypedPickleFactory<FilePath> {
        protected Pickle pickle(FilePath object) {
            return new FilePathPickle(object);
        }
    }
}

