/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.SubTask;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.steps.durable_task.Messages;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.TryRepeatedly;

public class ExecutorPickle
extends Pickle {
    private static final Logger LOGGER = Logger.getLogger(ExecutorPickle.class.getName());
    private final Queue.Task task;

    private ExecutorPickle(Executor executor) {
        if (executor instanceof OneOffExecutor) {
            throw new IllegalArgumentException("OneOffExecutor not currently supported");
        }
        Queue.Executable exec = executor.getCurrentExecutable();
        if (exec == null) {
            throw new IllegalArgumentException("cannot save an Executor that is not running anything");
        }
        SubTask parent = exec.getParent();
        Queue.Task task = this.task = parent instanceof Queue.Task ? (Queue.Task)parent : parent.getOwnerTask();
        if (this.task instanceof Queue.TransientTask) {
            throw new IllegalArgumentException("cannot save a TransientTask");
        }
    }

    public ListenableFuture<Executor> rehydrate(final FlowExecutionOwner owner) {
        return new TryRepeatedly<Executor>(1, 0){
            long itemID;

            protected Executor tryResolve() throws Exception {
                Queue.Item item;
                if (this.itemID == 0L) {
                    item = Queue.getInstance().schedule2(ExecutorPickle.this.task, 0, new Action[0]).getItem();
                    if (item == null) {
                        throw new IllegalStateException("queue refused " + ExecutorPickle.this.task);
                    }
                    this.itemID = item.getId();
                } else {
                    item = Queue.getInstance().getItem(this.itemID);
                    if (item == null) {
                        throw new IllegalStateException("queue lost item #" + this.itemID);
                    }
                }
                Future future = item.getFuture().getStartCondition();
                if (!future.isDone()) {
                    return null;
                }
                if (future.isCancelled()) {
                    throw new AbortException("Queue item was canceled.");
                }
                Queue.Executable exec = (Queue.Executable)future.get();
                Executor e = Executor.of((Queue.Executable)exec);
                if (e != null) {
                    return e;
                }
                throw new IllegalStateException(exec + " was scheduled but no executor claimed it");
            }

            protected FlowExecutionOwner getOwner() {
                return owner;
            }

            protected void printWaitingMessage(TaskListener listener) {
                Queue.Item item = Queue.getInstance().getItem(this.itemID);
                String message = Messages.ExecutorPickle_waiting_to_resume(ExecutorPickle.this.task.getFullDisplayName());
                if (item == null) {
                    listener.getLogger().println(message);
                    return;
                }
                CauseOfBlockage causeOfBlockage = item.getCauseOfBlockage();
                if (causeOfBlockage != null) {
                    listener.getLogger().print(message + ": ");
                    causeOfBlockage.print(listener);
                } else {
                    listener.getLogger().println(message);
                }
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                Queue.Item item = Queue.getInstance().getItem(this.itemID);
                if (item != null && !Queue.getInstance().cancel(item)) {
                    LOGGER.log(Level.WARNING, "failed to cancel {0}", item);
                }
                return super.cancel(mayInterruptIfRunning);
            }

            public String toString() {
                Queue.Item item = Queue.getInstance().getItem(this.itemID);
                if (item != null) {
                    return "Trying to schedule " + ExecutorPickle.this.task.getFullDisplayName() + "; blockage: " + item.getCauseOfBlockage();
                }
                return "Trying to locate queue item #" + this.itemID;
            }
        };
    }

    @Extension
    public static final class Factory
    extends SingleTypedPickleFactory<Executor> {
        protected Pickle pickle(Executor object) {
            return new ExecutorPickle(object);
        }
    }
}

