/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.Extension;
import hudson.model.Computer;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.TryRepeatedly;

public class ComputerPickle
extends Pickle {
    private final String slave;

    private ComputerPickle(Computer v) {
        this.slave = v.getName();
    }

    public ListenableFuture<Computer> rehydrate(FlowExecutionOwner owner) {
        return new TryRepeatedly<Computer>(1){

            protected Computer tryResolve() {
                Jenkins j = Jenkins.getInstance();
                if (j == null) {
                    return null;
                }
                return j.getComputer(ComputerPickle.this.slave);
            }

            public String toString() {
                return "Looking for computer named \u2018" + ComputerPickle.this.slave + "\u2019";
            }
        };
    }

    @Extension
    public static final class Factory
    extends SingleTypedPickleFactory<Computer> {
        protected Pickle pickle(Computer computer) {
            return new ComputerPickle(computer);
        }
    }
}

