/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.durable_task;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.util.Timer;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public abstract class DurableTaskStep
extends AbstractStepImpl {
    private static final Logger LOGGER = Logger.getLogger(DurableTaskStep.class.getName());
    private boolean returnStdout;
    private String encoding = "UTF-8";
    private boolean returnStatus;

    protected abstract DurableTask task();

    public boolean isReturnStdout() {
        return this.returnStdout;
    }

    @DataBoundSetter
    public void setReturnStdout(boolean returnStdout) {
        this.returnStdout = returnStdout;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isReturnStatus() {
        return this.returnStatus;
    }

    @DataBoundSetter
    public void setReturnStatus(boolean returnStatus) {
        this.returnStatus = returnStatus;
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="recurrencePeriod is set in onResume, not deserialization")
    public static final class Execution
    extends AbstractStepExecutionImpl
    implements Runnable {
        private static final long MIN_RECURRENCE_PERIOD = 250L;
        private static final long MAX_RECURRENCE_PERIOD = 15000L;
        private static final float RECURRENCE_PERIOD_BACKOFF = 1.2f;
        @Inject(optional=true)
        private transient DurableTaskStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        private transient long recurrencePeriod;
        private Controller controller;
        private String node;
        private String remote;
        private boolean returnStdout;
        private String encoding;
        private boolean returnStatus;
        private static final long serialVersionUID = 1L;

        public boolean start() throws Exception {
            this.returnStdout = this.step.returnStdout;
            this.encoding = this.step.encoding;
            this.returnStatus = this.step.returnStatus;
            this.node = FilePathUtils.getNodeName((FilePath)this.ws);
            DurableTask task = this.step.task();
            if (this.returnStdout) {
                task.captureOutput();
            }
            this.controller = task.launch(this.env, this.ws, this.launcher, this.listener);
            this.remote = this.ws.getRemote();
            this.setupTimer();
            return false;
        }

        @CheckForNull
        private FilePath getWorkspace() throws AbortException {
            boolean directory;
            if (this.ws == null) {
                this.ws = FilePathUtils.find((String)this.node, (String)this.remote);
                if (this.ws == null) {
                    LOGGER.log(Level.FINE, "Jenkins is not running, no such node {0}, or it is offline", this.node);
                    return null;
                }
            }
            try {
                directory = this.ws.isDirectory();
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, this.node + " is evidently offline now", x);
                this.ws = null;
                return null;
            }
            if (!directory) {
                throw new AbortException("missing workspace " + this.remote + " on " + this.node);
            }
            return this.ws;
        }

        @Nonnull
        private PrintStream logger() {
            TaskListener l = this.listener;
            if (l == null) {
                StepContext context = this.getContext();
                try {
                    l = (TaskListener)context.get(TaskListener.class);
                    if (l != null) {
                        LOGGER.log(Level.WARNING, "JENKINS-34021: DurableTaskStep.Execution.listener not restored in {0}", context);
                    } else {
                        LOGGER.log(Level.WARNING, "JENKINS-34021: TaskListener not even available upon request in {0}", context);
                        l = new LogTaskListener(LOGGER, Level.FINE);
                    }
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "JENKINS-34021: could not get TaskListener in " + context, x);
                    l = new LogTaskListener(LOGGER, Level.FINE);
                }
            }
            return l.getLogger();
        }

        public void stop(Throwable cause) throws Exception {
            FilePath workspace = this.getWorkspace();
            if (workspace != null) {
                this.logger().println("Sending interrupt signal to process");
                LOGGER.log(Level.FINE, "stopping process", cause);
                this.controller.stop(workspace, this.launcher);
            } else {
                this.logger().println("Could not connect to " + this.node + " to send interrupt signal to process");
            }
        }

        public String getStatus() {
            try {
                FilePath workspace = this.getWorkspace();
                if (workspace != null) {
                    return this.controller.getDiagnostics(workspace, this.launcher);
                }
                return "waiting to reconnect to " + this.remote + " on " + this.node;
            }
            catch (IOException | InterruptedException x) {
                return "failed to look up workspace: " + x;
            }
        }

        @Override
        public void run() {
            try {
                this.check();
            }
            finally {
                if (this.recurrencePeriod > 0L) {
                    Timer.get().schedule(this, this.recurrencePeriod, TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() {
            FilePath workspace;
            try {
                workspace = this.getWorkspace();
            }
            catch (AbortException x) {
                this.recurrencePeriod = 0L;
                this.getContext().onFailure((Throwable)x);
                return;
            }
            if (workspace == null) {
                return;
            }
            final AtomicReference<Thread> t = new AtomicReference<Thread>(Thread.currentThread());
            Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    Thread _t = (Thread)t.get();
                    if (_t != null) {
                        _t.interrupt();
                    }
                }
            }, 10L, TimeUnit.SECONDS);
            try {
                if (this.controller.writeLog(workspace, (OutputStream)this.logger())) {
                    this.getContext().saveState();
                    this.recurrencePeriod = 250L;
                } else {
                    this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * 1.2f), 15000L);
                }
                Integer exitCode = this.controller.exitStatus(workspace, this.launcher);
                if (exitCode == null) {
                    LOGGER.log(Level.FINE, "still running in {0} on {1}", new Object[]{this.remote, this.node});
                } else {
                    if (this.controller.writeLog(workspace, (OutputStream)this.logger())) {
                        LOGGER.log(Level.FINE, "last-minute output in {0} on {1}", new Object[]{this.remote, this.node});
                    }
                    t.set(null);
                    if (this.returnStatus || exitCode == 0) {
                        this.getContext().onSuccess(this.returnStatus ? exitCode : (this.returnStdout ? new String(this.controller.getOutput(workspace, this.launcher), this.encoding) : null));
                    } else {
                        if (this.returnStdout) {
                            this.listener.getLogger().write(this.controller.getOutput(workspace, this.launcher));
                        }
                        this.getContext().onFailure((Throwable)new AbortException("script returned exit code " + exitCode));
                    }
                    this.recurrencePeriod = 0L;
                    this.controller.cleanup(workspace);
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.FINE, "could not check " + workspace, x);
                this.ws = null;
            }
            catch (InterruptedException x) {
                LOGGER.log(Level.FINE, "could not check " + workspace, x);
                this.ws = null;
            }
            finally {
                t.set(null);
            }
        }

        public void onResume() {
            super.onResume();
            this.setupTimer();
        }

        private void setupTimer() {
            this.recurrencePeriod = 250L;
            Timer.get().schedule(this, this.recurrencePeriod, TimeUnit.MILLISECONDS);
        }
    }

    public static abstract class DurableTaskStepDescriptor
    extends AbstractStepDescriptorImpl {
        public static final String defaultEncoding = "UTF-8";

        protected DurableTaskStepDescriptor() {
            super(Execution.class);
        }

        public FormValidation doCheckEncoding(@QueryParameter boolean returnStdout, @QueryParameter String encoding) {
            try {
                Charset.forName(encoding);
            }
            catch (Exception x) {
                return FormValidation.error((Throwable)x, (String)"Unrecognized encoding");
            }
            if (!returnStdout && !encoding.equals(defaultEncoding)) {
                return FormValidation.warning((String)"encoding is ignored unless returnStdout is checked.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReturnStatus(@QueryParameter boolean returnStdout, @QueryParameter boolean returnStatus) {
            if (returnStdout && returnStatus) {
                return FormValidation.error((String)"You may not select both returnStdout and returnStatus.");
            }
            return FormValidation.ok();
        }
    }
}

