/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URL;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.actions.ChangeRequestAction;

@Extension
public class BranchNameContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(Job j, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        BranchProjectFactory projectFactory;
        ItemGroup parent = j.getParent();
        if (parent instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)j)) {
            SCMHead head = projectFactory.getBranch(j).getHead();
            envs.put("BRANCH_NAME", head.getName());
            ChangeRequestAction cr = (ChangeRequestAction)head.getAction(ChangeRequestAction.class);
            if (cr != null) {
                envs.putIfNotNull("CHANGE_ID", cr.getId());
                URL u = cr.getURL();
                if (u != null) {
                    envs.put("CHANGE_URL", u.toString());
                }
                envs.putIfNotNull("CHANGE_TITLE", cr.getTitle());
                envs.putIfNotNull("CHANGE_AUTHOR", cr.getAuthor());
                envs.putIfNotNull("CHANGE_AUTHOR_DISPLAY_NAME", cr.getAuthorDisplayName());
                envs.putIfNotNull("CHANGE_AUTHOR_EMAIL", cr.getAuthorEmail());
                SCMHead target = cr.getTarget();
                if (target != null) {
                    envs.put("CHANGE_TARGET", target.getName());
                }
            }
        }
    }
}

