/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EngineUtil {
    public static String readLine(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int ch;
        while ((ch = inputStream.read()) >= 0 && ch != 10) {
            byteArrayOutputStream.write(ch);
        }
        return byteArrayOutputStream.toString("UTF-8").trim();
    }

    public static String readChars(InputStream inputStream, int len) throws IOException {
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)inputStream.read();
        }
        return new String(buf, "UTF-8");
    }

    protected static Properties readResponseHeaders(BufferedInputStream inputStream) throws IOException {
        Properties response = new Properties();
        String line;
        while ((line = EngineUtil.readLine(inputStream)).length() != 0) {
            int idx = line.indexOf(58);
            response.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
        }
        return response;
    }

    static void closeAndLogFailures(@CheckForNull Closeable toClose, @Nonnull Logger logger, @Nonnull String closeableName, @Nonnull String closeableOwner) {
        if (toClose == null) {
            return;
        }
        try {
            toClose.close();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, String.format("Failed to close %s of %s", closeableName, closeableOwner), ex);
        }
    }
}

