/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven3.launcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.Maven;
import org.apache.maven.cli.MavenExecutionRequestBuilder;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maven32Launcher {
    private static HudsonMavenExecutionResult hudsonMavenExecutionResult;
    private static ExecutionListener mavenExecutionListener;
    private static List<EventSpy> eventSpiesList;

    public static ExecutionListener getMavenExecutionListener() {
        return mavenExecutionListener;
    }

    public static void setMavenExecutionListener(ExecutionListener listener) {
        mavenExecutionListener = listener;
    }

    public static List<EventSpy> getEventSpies() {
        return eventSpiesList;
    }

    public static void setEventSpies(List<EventSpy> theEventSpies) {
        eventSpiesList = theEventSpies;
    }

    public static HudsonMavenExecutionResult getMavenExecutionResult() {
        return hudsonMavenExecutionResult;
    }

    public static void setMavenExecutionResult(HudsonMavenExecutionResult result) {
        hudsonMavenExecutionResult = result;
    }

    public static int main(String[] args) throws Exception {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            ClassRealm containerRealm = (ClassRealm)Thread.currentThread().getContextClassLoader();
            ContainerConfiguration cc = new DefaultContainerConfiguration().setName("maven").setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true);
            DefaultPlexusContainer container = new DefaultPlexusContainer(cc);
            Slf4jLoggerManager mavenLoggerManager = new Slf4jLoggerManager();
            container.setLoggerManager((LoggerManager)mavenLoggerManager);
            Maven maven = (Maven)container.lookup("org.apache.maven.Maven", "default");
            EventSpyDispatcher eventSpyDispatcher = (EventSpyDispatcher)container.lookup(EventSpyDispatcher.class);
            if (eventSpiesList != null && !eventSpiesList.isEmpty()) {
                ArrayList<EventSpy> eventSpies = eventSpyDispatcher.getEventSpies();
                if (eventSpies == null) {
                    eventSpies = new ArrayList<EventSpy>(1);
                }
                eventSpies.addAll(eventSpiesList);
                List spies = container.lookupList(EventSpy.class);
                if (spies != null && !spies.isEmpty()) {
                    eventSpies.addAll(spies);
                }
                eventSpyDispatcher.setEventSpies(eventSpies);
            }
            MavenExecutionRequest request = Maven32Launcher.getMavenExecutionRequest(args, container);
            MavenExecutionResult result = maven.execute(request);
            hudsonMavenExecutionResult = new HudsonMavenExecutionResult(result);
            int n = 0;
            return n;
        }
        catch (ComponentLookupException e) {
            throw new Exception(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    private static MavenExecutionRequest getMavenExecutionRequest(String[] args, DefaultPlexusContainer container) throws Exception {
        MavenExecutionRequestBuilder mavenExecutionRequestBuilder = (MavenExecutionRequestBuilder)container.lookup(MavenExecutionRequestBuilder.class);
        MavenExecutionRequest request = mavenExecutionRequestBuilder.getMavenExecutionRequest(args, System.out);
        if (mavenExecutionListener != null) {
            request.setExecutionListener(mavenExecutionListener);
        }
        return request;
    }
}

