/*
 * Decompiled with CFR 0.152.
 */
package org.koshuke.stapler.simile.timeline;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.koshuke.stapler.simile.timeline.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineEventList
extends ArrayList<Event>
implements HttpResponse {
    private static SimpleDateFormat SDF = new SimpleDateFormat("MMM dd yyyy HH:mm:ss 'GMT'Z", Locale.ENGLISH);

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(Date.class, new JsonValueProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processArrayValue(Object value, JsonConfig jsonConfig) {
                if (value == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = SDF;
                synchronized (simpleDateFormat) {
                    return SDF.format(value);
                }
            }

            public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
                return this.processArrayValue(value, jsonConfig);
            }
        });
        JSONObject o = new JSONObject();
        o.put("events", (Object)JSONArray.fromObject((Object)this, (JsonConfig)config));
        rsp.setContentType("application/javascript;charset=UTF-8");
        o.write((Writer)rsp.getWriter());
    }
}

