/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.conditionalbuildstep.singlestep;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.tasks.BuildStep;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.BuildStepRunner;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.core.AlwaysRun;
import org.jenkinsci.plugins.conditionalbuildstep.lister.DefaultBuilderDescriptorLister;
import org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder;

public class JobUpdater {
    public static boolean updateBuilders(FreeStyleProject project) throws IOException {
        if (project == null) {
            return false;
        }
        DescribableList builders = project.getBuildersList();
        DefaultBuilderDescriptorLister builderLister = new DefaultBuilderDescriptorLister();
        List<? extends Descriptor<? extends BuildStep>> allowed = builderLister.getAllowedBuilders((AbstractProject<?, ?>)project);
        ArrayList<Builder> replace = new ArrayList<Builder>();
        for (Builder builder : builders) {
            if (allowed.contains(builder.getDescriptor())) {
                replace.add(new SingleConditionalBuilder((BuildStep)builder, (RunCondition)new AlwaysRun(), (BuildStepRunner)new BuildStepRunner.Fail()));
                continue;
            }
            replace.add(builder);
        }
        builders.replaceBy(replace);
        return true;
    }
}

