/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import com.sun.jna.Pointer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvnet.solaris.libzfs.ZFSContainer;
import org.jvnet.solaris.libzfs.ZFSException;
import org.jvnet.solaris.libzfs.ZFSFileSystem;
import org.jvnet.solaris.libzfs.ZFSObject;
import org.jvnet.solaris.libzfs.ZFSPool;
import org.jvnet.solaris.libzfs.ZFSType;
import org.jvnet.solaris.libzfs.jna.libzfs;
import org.jvnet.solaris.libzfs.jna.libzfs_handle_t;
import org.jvnet.solaris.libzfs.jna.zfs_handle_t;
import org.jvnet.solaris.libzfs.jna.zpool_handle_t;
import org.jvnet.solaris.nvlist.jna.nvlist_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibZFS
implements ZFSContainer {
    private libzfs_handle_t handle = libzfs.LIBZFS.libzfs_init();

    public List<ZFSFileSystem> roots() {
        final ArrayList<ZFSFileSystem> r = new ArrayList<ZFSFileSystem>();
        libzfs.LIBZFS.zfs_iter_root(this.handle, new libzfs.zfs_iter_f(){

            public int callback(zfs_handle_t handle, Pointer arg) {
                r.add(new ZFSFileSystem(LibZFS.this, handle));
                return 0;
            }
        }, null);
        return r;
    }

    public List<ZFSPool> pools() {
        final ArrayList<ZFSPool> r = new ArrayList<ZFSPool>();
        libzfs.LIBZFS.zpool_iter(this.handle, new libzfs.zpool_iter_f(){

            public int callback(zpool_handle_t handle, Pointer arg) {
                r.add(new ZFSPool(LibZFS.this, handle));
                return 0;
            }
        }, null);
        return r;
    }

    public ZFSPool getPool(String name) {
        zpool_handle_t h = libzfs.LIBZFS.zpool_open(this.handle, name);
        if (h == null) {
            return null;
        }
        return new ZFSPool(this, h);
    }

    public boolean exists(String dataSetName) {
        boolean exists = this.exists(dataSetName, EnumSet.allOf(ZFSType.class));
        return exists;
    }

    public boolean exists(String name, Set<ZFSType> typeMask) {
        int mask = 0;
        for (ZFSType t : typeMask) {
            mask |= t.code;
        }
        boolean exists = libzfs.LIBZFS.zfs_dataset_exists(this.handle, name, mask);
        return exists;
    }

    public boolean exists(String dataSetName, ZFSType type) {
        boolean exists = this.exists(dataSetName, EnumSet.of(type));
        return exists;
    }

    public <T extends ZFSObject> T create(String dataSetName, Class<T> type) {
        return (T)((ZFSObject)type.cast(this.create(dataSetName, ZFSType.fromType(type), null)));
    }

    public ZFSObject create(String dataSetName, ZFSType type, Map<String, String> props) {
        nvlist_t nvl = nvlist_t.alloc(1);
        if (props != null) {
            for (Map.Entry<String, String> e : props.entrySet()) {
                nvl.put(e.getKey(), e.getValue());
            }
        }
        String[] dirs = dataSetName.split("/");
        StringBuilder sb = new StringBuilder(dirs[0]);
        for (int i = 1; i < dirs.length; ++i) {
            sb.append('/').append(dirs[i]);
            if (this.exists(sb.toString()) || libzfs.LIBZFS.zfs_create(this.handle, sb.toString(), type.code, nvl) == 0) continue;
            throw new ZFSException(this, "Failed to create " + dataSetName);
        }
        ZFSObject dataSet = this.open(dataSetName);
        return dataSet;
    }

    public ZFSObject open(String dataSetName) {
        ZFSObject dataSet = this.open(dataSetName, 7);
        return dataSet;
    }

    public ZFSObject open(String dataSetName, int mask) {
        zfs_handle_t h = libzfs.LIBZFS.zfs_open(this.handle, dataSetName, mask);
        if (h == null) {
            int err = libzfs.LIBZFS.libzfs_errno(this.handle);
            if (err == 0) {
                return null;
            }
            throw new ZFSException(this);
        }
        return ZFSObject.create(this, h);
    }

    public <T extends ZFSObject> T open(String dataSetName, Class<T> type) {
        return (T)((ZFSObject)type.cast(this.open(dataSetName, ZFSType.fromType(type).code)));
    }

    public ZFSFileSystem getFileSystemByMountPoint(File dir) {
        dir = dir.getAbsoluteFile();
        for (ZFSFileSystem f : this.descendants(ZFSFileSystem.class)) {
            File mp = f.getMountPoint();
            if (mp == null || !mp.equals(dir)) continue;
            return f;
        }
        return null;
    }

    public List<ZFSFileSystem> children() {
        return this.roots();
    }

    @Override
    public <T extends ZFSObject> List<T> children(Class<T> type) {
        if (type.isAssignableFrom(ZFSFileSystem.class)) {
            return this.roots();
        }
        return Collections.emptyList();
    }

    @Override
    public List<ZFSObject> descendants() {
        return this.children(ZFSObject.class);
    }

    @Override
    public <T extends ZFSObject> List<T> descendants(Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        r.addAll(this.children(type));
        for (ZFSFileSystem p : this.roots()) {
            r.addAll(p.descendants(type));
        }
        return r;
    }

    public libzfs_handle_t getHandle() {
        return this.handle;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public synchronized void dispose() {
        if (this.handle != null) {
            libzfs.LIBZFS.libzfs_fini(this.handle);
            this.handle = null;
        }
    }
}

