/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.SurefireReport;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.util.List;
import java.util.Map;

public class SurefireAggregatedReport
extends AggregatedTestResultAction
implements MavenAggregatedReport {
    SurefireAggregatedReport(MavenModuleSetBuild owner) {
        super((AbstractBuild)owner);
    }

    @Override
    public void update(Map<MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
        super.update(((MavenModuleSetBuild)this.owner).findModuleBuildActions(SurefireReport.class));
    }

    public Class<SurefireReport> getIndividualActionType() {
        return SurefireReport.class;
    }

    @Override
    public Action getProjectAction(MavenModuleSet moduleSet) {
        return new TestResultProjectAction((AbstractProject)moduleSet);
    }

    protected String getChildName(AbstractTestResultAction tr) {
        return ((MavenModule)tr.owner.getProject()).getModuleName().toString();
    }

    public MavenBuild resolveChild(AggregatedTestResultAction.Child child) {
        MavenModuleSet mms = (MavenModuleSet)this.owner.getProject();
        MavenModule m = mms.getModule(child.name);
        if (m != null) {
            return (MavenBuild)m.getBuildByNumber(child.build);
        }
        return null;
    }

    public SurefireReport getChildReport(AggregatedTestResultAction.Child child) {
        MavenBuild b = this.resolveChild(child);
        if (b == null) {
            return null;
        }
        return (SurefireReport)b.getAction(SurefireReport.class);
    }

    public String getTestResultPath(CaseResult it) {
        StringBuilder path = new StringBuilder("../");
        path.append(it.getOwner().getProject().getShortUrl());
        path.append(it.getOwner().getNumber());
        path.append("/");
        path.append(this.getUrlName());
        path.append("/");
        path.append(it.getRelativePathFrom(null));
        return path.toString();
    }
}

