/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.maven.AbstractMavenBuilder;
import hudson.maven.ExecutedMojo;
import hudson.maven.Maven3ConsoleFormatter;
import hudson.maven.Maven3FailureLogger;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenModule;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReporter;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.TestFailureDetector;
import hudson.maven.util.ExecutionEventLogger;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Maven3Builder
extends AbstractMavenBuilder
implements DelegatingCallable<Result, IOException> {
    private final boolean profile = MavenProcessFactory.profile;
    HudsonMavenExecutionResult mavenExecutionResult;
    Class<?> maven3MainClass;
    Class<?> maven3LauncherClass;
    boolean supportEventSpy = false;
    public static boolean markAsSuccess;
    private static final long serialVersionUID = 1L;
    private static final java.util.logging.Logger LOGGER;
    public static boolean DUMP_PERFORMANCE_COUNTERS;

    protected Maven3Builder(Maven3BuilderRequest maven3BuilderRequest) {
        super(maven3BuilderRequest.listener, maven3BuilderRequest.modules, maven3BuilderRequest.goals, maven3BuilderRequest.systemProps);
        this.sourceProxies.putAll(maven3BuilderRequest.proxies);
        this.proxies = new HashMap();
        for (Map.Entry e : this.sourceProxies.entrySet()) {
            this.proxies.put(e.getKey(), new AbstractMavenBuilder.FilterImpl((MavenBuildProxy2)e.getValue(), maven3BuilderRequest.mavenBuildInformation));
        }
        this.maven3LauncherClass = maven3BuilderRequest.maven3LauncherClass;
        this.maven3MainClass = maven3BuilderRequest.maven3MainClass;
        this.supportEventSpy = maven3BuilderRequest.supportEventSpy;
    }

    public Result call() throws IOException {
        this.configureConsoleLogging();
        try {
            MavenExecutionListener mavenExecutionListener;
            this.initializeAsynchronousExecutions();
            MavenExecutionListener mavenExecutionListener2 = mavenExecutionListener = this.supportEventSpy ? new JenkinsEventSpy(this) : new MavenExecutionListener(this);
            if (this.supportEventSpy) {
                Method setEventSpiesMethod = this.maven3LauncherClass.getMethod("setEventSpies", List.class);
                setEventSpiesMethod.invoke(null, Collections.singletonList(mavenExecutionListener));
            } else {
                Method setMavenExecutionListenerMethod = this.maven3LauncherClass.getMethod("setMavenExecutionListener", ExecutionListener.class);
                setMavenExecutionListenerMethod.invoke(null, mavenExecutionListener);
            }
            markAsSuccess = false;
            this.registerSystemProperties();
            PrintStream logger = this.listener.getLogger();
            logger.println(this.formatArgs(this.goals));
            Method launchMethod = this.maven3MainClass.getMethod("launch", String[].class);
            Integer res = (Integer)launchMethod.invoke(null, new Object[]{this.goals.toArray(new String[this.goals.size()])});
            int r = res;
            long startTime = System.nanoTime();
            Result waitForAsyncExecutionsResult = this.waitForAsynchronousExecutions();
            if (waitForAsyncExecutionsResult != null) {
                Result result = waitForAsyncExecutionsResult;
                return result;
            }
            mavenExecutionListener.overheadTime += System.nanoTime() - startTime;
            if (this.profile) {
                NumberFormat n = NumberFormat.getInstance();
                logger.println("Total overhead was " + this.format(n, mavenExecutionListener.overheadTime) + "ms");
                Channel ch = Channel.current();
                logger.println("Class loading " + this.format(n, ch.classLoadingTime.get()) + "ms, " + ch.classLoadingCount + " classes");
                logger.println("Resource loading " + this.format(n, ch.resourceLoadingTime.get()) + "ms, " + ch.resourceLoadingCount + " times");
            }
            Method mavenExecutionResultGetMethod = this.maven3LauncherClass.getMethod("getMavenExecutionResult", null);
            this.mavenExecutionResult = (HudsonMavenExecutionResult)mavenExecutionResultGetMethod.invoke(null, (Object[])null);
            Maven3FailureLogger summary = new Maven3FailureLogger(mavenExecutionListener.logger);
            summary.setOptions(this.goals);
            summary.logFailures(this.mavenExecutionResult);
            if (r == 0 && this.mavenExecutionResult.getThrowables().isEmpty()) {
                if (mavenExecutionListener.hasTestFailures()) {
                    Result result = Result.UNSTABLE;
                    return result;
                }
                Result result = Result.SUCCESS;
                return result;
            }
            Result result = Result.FAILURE;
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (DUMP_PERFORMANCE_COUNTERS) {
                Channel.current().dumpPerformanceCounters(this.listener.error("Remoting stats"));
            }
        }
    }

    private void configureConsoleLogging() {
        Handler[] handlers;
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        for (Handler h : handlers = rootLogger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ((ConsoleHandler)h).setFormatter(new Maven3ConsoleFormatter());
        }
    }

    static {
        LOGGER = java.util.logging.Logger.getLogger(Maven3Builder.class.getName());
        DUMP_PERFORMANCE_COUNTERS = Boolean.getBoolean(Maven3Builder.class.getName() + ".dumpPerformanceCounters");
    }

    private static class MavenExecutionListener
    extends AbstractExecutionListener
    implements Serializable,
    ExecutionListener {
        private static final long serialVersionUID = 4942789836756366116L;
        private final AbstractMavenBuilder maven3Builder;
        private AtomicBoolean hasTestFailures = new AtomicBoolean();
        private Logger logger = LoggerFactory.getLogger(MavenExecutionListener.class);
        long overheadTime;
        private final Map<ModuleName, AbstractMavenBuilder.FilterImpl> proxies;
        private final Map<ModuleName, List<ExecutedMojo>> executedMojosPerModule = new ConcurrentHashMap<ModuleName, List<ExecutedMojo>>();
        private final Map<ModuleName, List<MavenReporter>> reporters;
        private final Map<ModuleName, Long> currentMojoStartPerModuleName = new ConcurrentHashMap<ModuleName, Long>();
        protected ExecutionEventLogger eventLogger;

        public MavenExecutionListener(AbstractMavenBuilder maven3Builder) {
            this.maven3Builder = maven3Builder;
            this.proxies = new ConcurrentHashMap<ModuleName, AbstractMavenBuilder.FilterImpl>(maven3Builder.proxies);
            for (ModuleName name : this.proxies.keySet()) {
                this.executedMojosPerModule.put(name, new CopyOnWriteArrayList());
            }
            this.reporters = new ConcurrentHashMap<ModuleName, List<MavenReporter>>(maven3Builder.reporters);
            this.eventLogger = new ExecutionEventLogger(this.logger);
        }

        public boolean hasTestFailures() {
            return this.hasTestFailures.get();
        }

        @CheckForNull
        private MavenBuildProxy2 getMavenBuildProxy2(MavenProject mavenProject) {
            for (Map.Entry<ModuleName, AbstractMavenBuilder.FilterImpl> entry : this.proxies.entrySet()) {
                if (entry.getKey().compareTo(new ModuleName(mavenProject)) != 0) continue;
                return entry.getValue();
            }
            return null;
        }

        private List<MavenReporter> getMavenReporters(MavenProject mavenProject) {
            return this.reporters.get(new ModuleName(mavenProject));
        }

        private long initMojoStartTime(MavenProject mavenProject) {
            long mojoStartTime = System.currentTimeMillis();
            this.currentMojoStartPerModuleName.put(new ModuleName(mavenProject), mojoStartTime);
            return mojoStartTime;
        }

        private Long getMojoStartTime(MavenProject mavenProject) {
            return this.currentMojoStartPerModuleName.get(new ModuleName(mavenProject));
        }

        public void projectDiscoveryStarted(ExecutionEvent event) {
            this.eventLogger.projectDiscoveryStarted(event);
        }

        public void sessionStarted(ExecutionEvent event) {
            this.eventLogger.sessionStarted(event);
            Map<ModuleName, MavenProject> buildingProjects = this.getSessionProjects(event);
            for (Map.Entry<ModuleName, AbstractMavenBuilder.FilterImpl> e : this.proxies.entrySet()) {
                MavenProject project = buildingProjects.get(e.getKey());
                if (project != null) {
                    for (MavenReporter mavenReporter : Util.fixNull(this.reporters.get(e.getKey()))) {
                        try {
                            mavenReporter.preBuild(e.getValue(), project, this.maven3Builder.listener);
                        }
                        catch (InterruptedException x) {
                            x.printStackTrace();
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                    }
                    continue;
                }
                LOGGER.fine("Project " + e.getKey() + " needs not be build");
                MavenBuildProxy2 proxy = e.getValue();
                proxy.start();
                proxy.setResult(Result.NOT_BUILT);
                proxy.end();
            }
        }

        public void sessionEnded(ExecutionEvent event) {
            this.debug("sessionEnded");
            this.eventLogger.sessionEnded(event);
            Map<ModuleName, MavenProject> buildingProjects = this.getSessionProjects(event);
            for (Map.Entry e : Util.fixNull(this.proxies.entrySet())) {
                MavenProject project = buildingProjects.get(e.getKey());
                if (project == null) continue;
                for (MavenReporter mavenReporter : this.reporters.get(e.getKey())) {
                    try {
                        mavenReporter.postBuild((MavenBuildProxy)e.getValue(), project, this.maven3Builder.listener);
                    }
                    catch (InterruptedException x) {
                        x.printStackTrace();
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
            }
        }

        private Map<ModuleName, MavenProject> getSessionProjects(ExecutionEvent event) {
            List projects = event.getSession().getProjects();
            this.debug("Projects to build: " + projects);
            HashMap<ModuleName, MavenProject> buildingProjects = new HashMap<ModuleName, MavenProject>();
            for (MavenProject p : projects) {
                buildingProjects.put(new ModuleName(p), p);
            }
            return buildingProjects;
        }

        public void projectSkipped(ExecutionEvent event) {
            this.debug("projectSkipped " + this.gav(event.getProject()));
            this.eventLogger.projectSkipped(event);
        }

        public void projectStarted(ExecutionEvent event) {
            this.debug("projectStarted " + this.gav(event.getProject()));
            this.recordProjectStarted(event);
            this.eventLogger.projectStarted(event);
        }

        private void recordProjectStarted(ExecutionEvent event) {
            MavenProject mavenProject = event.getProject();
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            if (mavenBuildProxy2 == null) {
                return;
            }
            mavenBuildProxy2.start();
            for (MavenReporter mavenReporter : Util.fixNull(mavenReporters)) {
                try {
                    mavenReporter.enterModule(mavenBuildProxy2, mavenProject, this.maven3Builder.listener);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void projectSucceeded(ExecutionEvent event) {
            this.debug("projectSucceeded " + this.gav(event.getProject()));
            this.recordProjectEnded(event, Result.SUCCESS);
            this.eventLogger.projectSucceeded(event);
        }

        public void projectFailed(ExecutionEvent event) {
            this.debug("projectFailed " + this.gav(event.getProject()));
            this.recordProjectEnded(event, Result.FAILURE);
            this.eventLogger.projectFailed(event);
        }

        private void recordProjectEnded(ExecutionEvent event, Result result) {
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(event.getProject());
            if (mavenBuildProxy2 == null) {
                return;
            }
            mavenBuildProxy2.setResult(result);
            List<MavenReporter> mavenReporters = this.getMavenReporters(event.getProject());
            for (MavenReporter mavenReporter : Util.fixNull(mavenReporters)) {
                try {
                    mavenReporter.postBuild(mavenBuildProxy2, event.getProject(), this.maven3Builder.listener);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            mavenBuildProxy2.end();
        }

        public void mojoSkipped(ExecutionEvent event) {
            this.debug("mojoSkipped " + this.mojoExec(event));
            this.eventLogger.mojoSkipped(event);
        }

        public void mojoStarted(ExecutionEvent event) {
            this.debug("mojoStarted " + this.mojoExec(event));
            this.recordMojoStarted(event);
            this.eventLogger.mojoStarted(event);
        }

        private void recordMojoStarted(ExecutionEvent event) {
            long startTime = this.initMojoStartTime(event.getProject());
            MavenProject mavenProject = event.getProject();
            MojoInfo mojoInfo = new MojoInfo(event, startTime);
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            if (mavenBuildProxy2 == null) {
                return;
            }
            for (MavenReporter mavenReporter : Util.fixNull(mavenReporters)) {
                try {
                    mavenReporter.preExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void mojoSucceeded(ExecutionEvent event) {
            this.debug("mojoSucceeded " + this.mojoExec(event));
            this.recordMojoEnded(event, null);
            this.eventLogger.mojoSucceeded(event);
        }

        private void recordMojoEnded(ExecutionEvent event, Exception problem) {
            MavenProject mavenProject = event.getProject();
            MojoInfo mojoInfo = new MojoInfo(event, this.getMojoStartTime(event.getProject()));
            this.recordExecutionTime(event, mojoInfo);
            List<MavenReporter> mavenReporters = this.getMavenReporters(mavenProject);
            MavenBuildProxy2 mavenBuildProxy2 = this.getMavenBuildProxy2(mavenProject);
            if (mavenBuildProxy2 == null) {
                return;
            }
            mavenBuildProxy2.setExecutedMojos(this.executedMojosPerModule.get(new ModuleName(event)));
            for (MavenReporter mavenReporter : Util.fixNull(mavenReporters)) {
                try {
                    mavenReporter.postExecute(mavenBuildProxy2, mavenProject, mojoInfo, this.maven3Builder.listener, problem);
                    if (!(mavenReporter instanceof TestFailureDetector) || !((TestFailureDetector)mavenReporter).hasTestFailures()) continue;
                    this.hasTestFailures.compareAndSet(false, true);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    mavenBuildProxy2.setResult(Result.FAILURE);
                    e.printStackTrace();
                }
            }
        }

        private void recordExecutionTime(ExecutionEvent event, MojoInfo mojoInfo) {
            Long startTime;
            MavenProject p = event.getProject();
            List<ExecutedMojo> m = this.executedMojosPerModule.get(new ModuleName(p));
            if (m == null) {
                m = new CopyOnWriteArrayList<ExecutedMojo>();
                this.executedMojosPerModule.put(new ModuleName(p), m);
            }
            m.add(new ExecutedMojo(mojoInfo, (startTime = this.getMojoStartTime(event.getProject())) == null ? 0L : System.currentTimeMillis() - startTime));
        }

        public void mojoFailed(ExecutionEvent event) {
            this.debug("mojoFailed " + this.mojoExec(event));
            this.recordMojoEnded(event, this.getExecutionException(event));
            this.eventLogger.mojoFailed(event);
        }

        private void debug(String msg) {
            LOGGER.fine(msg);
        }

        private Exception getExecutionException(ExecutionEvent event) {
            try {
                return event.getException();
            }
            catch (NoSuchMethodError e) {
                return new MojoExecutionException(event.getMojoExecution() + " failed");
            }
        }

        public void forkStarted(ExecutionEvent event) {
            LOGGER.fine("mojo forkStarted " + this.mojoExec(event));
            this.recordMojoStarted(event);
        }

        public void forkSucceeded(ExecutionEvent event) {
            LOGGER.fine("mojo forkSucceeded " + this.mojoExec(event));
            this.recordMojoEnded(event, null);
        }

        public void forkFailed(ExecutionEvent event) {
            LOGGER.fine("mojo forkFailed " + this.mojoExec(event));
            this.recordMojoEnded(event, this.getExecutionException(event));
        }

        public void forkedProjectStarted(ExecutionEvent event) {
            this.debug("forkedProjectStarted " + this.gav(event.getProject()));
            this.eventLogger.forkedProjectStarted(event);
        }

        public void forkedProjectSucceeded(ExecutionEvent event) {
            this.debug("forkedProjectSucceeded " + this.gav(event.getProject()));
            this.eventLogger.forkedProjectSucceeded(event);
        }

        public void forkedProjectFailed(ExecutionEvent event) {
            this.debug("forkedProjectFailed " + this.gav(event.getProject()));
        }

        private String gav(MavenProject p) {
            return String.format("%s:%s:%s", p.getGroupId(), p.getArtifactId(), p.getVersion());
        }

        private String mojoExec(ExecutionEvent event) {
            MojoExecution me = event.getMojoExecution();
            return String.format("%s:%s:%s(%s)", me.getGroupId(), me.getArtifactId(), me.getVersion(), me.getExecutionId());
        }
    }

    private static final class JenkinsEventSpy
    extends MavenExecutionListener
    implements EventSpy,
    Serializable {
        private static final long serialVersionUID = 4942789836756366117L;

        public JenkinsEventSpy(AbstractMavenBuilder maven3Builder) {
            super(maven3Builder);
            this.eventLogger = new ExecutionEventLogger(){

                public void projectDiscoveryStarted(ExecutionEvent event) {
                }

                public void sessionStarted(ExecutionEvent event) {
                }

                public void sessionEnded(ExecutionEvent event) {
                }

                public void projectSkipped(ExecutionEvent event) {
                }

                public void projectStarted(ExecutionEvent event) {
                }

                public void mojoSkipped(ExecutionEvent event) {
                }

                @Override
                public void mojoStarted(ExecutionEvent event) {
                }

                public void forkStarted(ExecutionEvent event) {
                }

                public void forkSucceeded(ExecutionEvent event) {
                }

                public void forkedProjectStarted(ExecutionEvent event) {
                }

                public void projectSucceeded(ExecutionEvent event) {
                }

                public void projectFailed(ExecutionEvent event) {
                }

                public void forkFailed(ExecutionEvent event) {
                }

                public void mojoSucceeded(ExecutionEvent event) {
                }

                public void mojoFailed(ExecutionEvent event) {
                }

                public void forkedProjectSucceeded(ExecutionEvent event) {
                }

                public void forkedProjectFailed(ExecutionEvent event) {
                }
            };
        }

        public void init(EventSpy.Context context) throws Exception {
        }

        public void onEvent(Object event) throws Exception {
            if (event instanceof ExecutionEvent) {
                ExecutionEvent.Type eventType = ((ExecutionEvent)event).getType();
                switch (eventType) {
                    case ProjectDiscoveryStarted: {
                        super.projectDiscoveryStarted((ExecutionEvent)event);
                        break;
                    }
                    case SessionStarted: {
                        super.sessionStarted((ExecutionEvent)event);
                        break;
                    }
                    case SessionEnded: {
                        super.sessionEnded((ExecutionEvent)event);
                        break;
                    }
                    case ProjectSkipped: {
                        super.projectSkipped((ExecutionEvent)event);
                        break;
                    }
                    case ProjectStarted: {
                        super.projectStarted((ExecutionEvent)event);
                        break;
                    }
                    case ProjectSucceeded: {
                        super.projectSucceeded((ExecutionEvent)event);
                        break;
                    }
                    case ProjectFailed: {
                        super.projectFailed((ExecutionEvent)event);
                        break;
                    }
                    case MojoSkipped: {
                        super.mojoSkipped((ExecutionEvent)event);
                        break;
                    }
                    case MojoStarted: {
                        super.mojoStarted((ExecutionEvent)event);
                        break;
                    }
                    case MojoSucceeded: {
                        super.mojoSucceeded((ExecutionEvent)event);
                        break;
                    }
                    case MojoFailed: {
                        super.mojoFailed((ExecutionEvent)event);
                        break;
                    }
                    case ForkStarted: {
                        super.forkedProjectStarted((ExecutionEvent)event);
                        break;
                    }
                    case ForkSucceeded: {
                        super.forkSucceeded((ExecutionEvent)event);
                        break;
                    }
                    case ForkFailed: {
                        super.forkFailed((ExecutionEvent)event);
                        break;
                    }
                    case ForkedProjectStarted: {
                        super.forkedProjectStarted((ExecutionEvent)event);
                        break;
                    }
                    case ForkedProjectSucceeded: {
                        super.forkedProjectSucceeded((ExecutionEvent)event);
                        break;
                    }
                    case ForkedProjectFailed: {
                        super.forkFailed((ExecutionEvent)event);
                        break;
                    }
                    default: {
                        LOGGER.fine("event not managed");
                    }
                }
            }
        }

        public void close() throws Exception {
        }
    }

    protected static class Maven3BuilderRequest {
        BuildListener listener;
        Map<ModuleName, MavenBuild.ProxyImpl2> proxies;
        Collection<MavenModule> modules;
        List<String> goals;
        Map<String, String> systemProps;
        MavenBuildInformation mavenBuildInformation;
        Class<?> maven3MainClass;
        Class<?> maven3LauncherClass;
        boolean supportEventSpy = false;

        protected Maven3BuilderRequest() {
        }
    }
}

