/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

class AggregatingClassLoader
extends ClassLoader {
    private final List<ClassLoader> sides;

    public AggregatingClassLoader(ClassLoader parent, List<ClassLoader> sides) {
        super(parent);
        this.sides = new ArrayList<ClassLoader>(sides);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.sides) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader cl : this.sides) {
            URL url = cl.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (ClassLoader cl : this.sides) {
            resources.addAll(Collections.list(cl.getResources(name)));
        }
        return Collections.enumeration(resources);
    }
}

