/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import javax.annotation.CheckForNull;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

class CpsGroovyShell
extends GroovyShell {
    @CheckForNull
    private final CpsFlowExecution execution;

    CpsGroovyShell(ClassLoader parent, @CheckForNull CpsFlowExecution execution, CompilerConfiguration cc) {
        super(parent, new Binding(), cc);
        this.execution = execution;
    }

    public void prepareScript(Script script) {
        if (script instanceof CpsScript) {
            CpsScript cs = (CpsScript)script;
            cs.execution = this.execution;
            try {
                cs.$initialize();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        Script s = super.parse(codeSource);
        if (this.execution != null) {
            this.execution.loadedScripts.put(s.getClass().getName(), codeSource.getScriptText());
        }
        this.prepareScript(s);
        return s;
    }

    Script reparse(String className, String text) throws CompilationFailedException {
        return super.parse(new GroovyCodeSource(text, className, "/groovy/shell"));
    }

    protected synchronized String generateScriptName() {
        if (this.execution != null) {
            return "Script" + (this.execution.loadedScripts.size() + 1) + ".groovy";
        }
        return super.generateScriptName();
    }
}

