/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private static final Comparator<MetadataGeneratorFactory> COMPARATOR = new Comparator<MetadataGeneratorFactory>(){

        @Override
        public int compare(MetadataGeneratorFactory o1, MetadataGeneratorFactory o2) {
            return Float.compare(o2.getPriority(), o1.getPriority());
        }
    };

    Utils() {
    }

    public static List<MetadataGeneratorFactory> sortMetadataGeneratorFactories(Collection<? extends MetadataGeneratorFactory> factories) {
        ArrayList<MetadataGeneratorFactory> result = new ArrayList<MetadataGeneratorFactory>(factories);
        Collections.sort(result, COMPARATOR);
        return result;
    }

    public static List<Metadata> prepareMetadata(List<? extends MetadataGenerator> generators, List<? extends Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator metadataGenerator : generators) {
            metadatas.addAll(metadataGenerator.prepare(artifacts));
        }
        return metadatas;
    }

    public static List<Metadata> finishMetadata(List<? extends MetadataGenerator> generators, List<? extends Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator metadataGenerator : generators) {
            metadatas.addAll(metadataGenerator.finish(artifacts));
        }
        return metadatas;
    }

    public static <T> List<T> combine(Collection<? extends T> first, Collection<? extends T> second) {
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static int getPolicy(RepositorySystemSession session, Artifact artifact, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getArtifactPolicy(session, new ResolutionErrorPolicyRequest((Object)artifact, repository));
    }

    public static int getPolicy(RepositorySystemSession session, Metadata metadata, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getMetadataPolicy(session, new ResolutionErrorPolicyRequest((Object)metadata, repository));
    }
}

