/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.lang.Klass;

public class StaticViewFacet
extends Facet {
    private final List<String> allowedExtensions = new ArrayList<String>();

    public StaticViewFacet(String ... allowedExtensions) {
        this(Arrays.asList(allowedExtensions));
    }

    public StaticViewFacet(Collection<String> allowedExtensions) {
        for (String extension : allowedExtensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(String ext) {
        if (!ext.startsWith(".")) {
            ext = '.' + ext;
        }
        this.allowedExtensions.add(ext);
    }

    @Override
    public void buildViewDispatchers(final MetaClass owner, List<Dispatcher> dispatchers) {
        dispatchers.add(new Dispatcher(){

            @Override
            public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                String next = req.tokens.peek();
                if (next == null) {
                    return false;
                }
                if (req.tokens.countRemainingTokens() > 1) {
                    return false;
                }
                if (req.getRequestURI().endsWith("/")) {
                    return false;
                }
                URL res = StaticViewFacet.this.findResource(owner.klass, next);
                if (res == null) {
                    return false;
                }
                req.tokens.next();
                if (1.traceable()) {
                    1.trace(req, rsp, "-> %s on <%s>", next, node);
                }
                rsp.serveFile(req, res);
                return true;
            }

            @Override
            public String toString() {
                return "static file for url=/VIEW" + StringUtils.join((Collection)StaticViewFacet.this.allowedExtensions, (String)"|");
            }
        });
    }

    protected URL findResource(Klass c, String fileName) {
        boolean ends = false;
        for (String ext : this.allowedExtensions) {
            if (!fileName.endsWith(ext)) continue;
            ends = true;
            break;
        }
        if (!ends) {
            return null;
        }
        while (c != null) {
            URL res = c.getResource(fileName);
            if (res != null) {
                return res;
            }
            c = c.getSuperClass();
        }
        return null;
    }

    @Override
    public RequestDispatcher createRequestDispatcher(RequestImpl request, Klass<?> type, Object it, String viewName) throws IOException {
        final Stapler stapler = request.getStapler();
        final URL res = this.findResource(type, viewName);
        if (res == null) {
            return null;
        }
        return new RequestDispatcher(){

            public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                stapler.serveStaticResource((HttpServletRequest)request, (StaplerResponse)new ResponseImpl(stapler, (HttpServletResponse)response), res, 0L);
            }

            public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean handleIndexRequest(RequestImpl req, ResponseImpl rsp, Object node, MetaClass nodeMetaClass) throws IOException, ServletException {
        URL res = this.findResource(nodeMetaClass.klass, "index.html");
        if (res == null) {
            return false;
        }
        rsp.serveFile(req, res);
        return true;
    }
}

