/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TimeToFloat;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.dom4j.Element;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.export.Exported;

public class CaseResult
extends hudson.tasks.test.TestResult
implements Comparable<CaseResult> {
    private static final Logger LOGGER = Logger.getLogger(CaseResult.class.getName());
    private final float duration;
    private final String className;
    private final String testName;
    private transient String safeName;
    private final boolean skipped;
    private final String skippedMessage;
    private final String errorStackTrace;
    private final String errorDetails;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Specific method to restore it")
    private transient SuiteResult parent;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Not guarded, though read in synchronized blocks")
    private transient ClassResult classResult;
    private final String stdout;
    private final String stderr;
    private int failedSince;
    private static final int HALF_MAX_SIZE = 500;
    private static final int HALF_MAX_FAILING_SIZE = 50000;
    static final Comparator<CaseResult> BY_AGE = new Comparator<CaseResult>(){

        @Override
        public int compare(CaseResult lhs, CaseResult rhs) {
            return lhs.getAge() - rhs.getAge();
        }
    };
    private static final long serialVersionUID = 1L;

    private static float parseTime(Element testCase) {
        String time = testCase.attributeValue("time");
        return new TimeToFloat(time).parse();
    }

    CaseResult(SuiteResult parent, Element testCase, String testClassName, boolean keepLongStdio) {
        String nameAttr = testCase.attributeValue("name");
        if (testClassName == null && nameAttr.contains(".")) {
            testClassName = nameAttr.substring(0, nameAttr.lastIndexOf(46));
            nameAttr = nameAttr.substring(nameAttr.lastIndexOf(46) + 1);
        }
        this.className = testClassName;
        this.testName = nameAttr;
        this.errorStackTrace = CaseResult.getError(testCase);
        this.errorDetails = CaseResult.getErrorMessage(testCase);
        this.parent = parent;
        this.duration = CaseResult.parseTime(testCase);
        this.skipped = CaseResult.isMarkedAsSkipped(testCase);
        this.skippedMessage = CaseResult.getSkippedMessage(testCase);
        Set<CaseResult> _this = Collections.singleton(this);
        this.stdout = CaseResult.possiblyTrimStdio(_this, keepLongStdio, testCase.elementText("system-out"));
        this.stderr = CaseResult.possiblyTrimStdio(_this, keepLongStdio, testCase.elementText("system-err"));
    }

    static String possiblyTrimStdio(Collection<CaseResult> results, boolean keepLongStdio, String stdio) {
        int halfMaxSize;
        if (stdio == null) {
            return null;
        }
        if (keepLongStdio) {
            return stdio;
        }
        int len = stdio.length();
        int middle = len - (halfMaxSize = CaseResult.halfMaxSize(results)) * 2;
        if (middle <= 0) {
            return stdio;
        }
        return stdio.subSequence(0, halfMaxSize) + "\n...[truncated " + middle + " chars]...\n" + stdio.subSequence(len - halfMaxSize, len);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Expected behavior")
    static String possiblyTrimStdio(Collection<CaseResult> results, boolean keepLongStdio, File stdio) throws IOException {
        int tailBytes;
        long len = stdio.length();
        if (keepLongStdio && len < 0x100000L) {
            return FileUtils.readFileToString((File)stdio);
        }
        int halfMaxSize = CaseResult.halfMaxSize(results);
        long middle = len - (long)(halfMaxSize * 2);
        if (middle <= 0L) {
            return FileUtils.readFileToString((File)stdio);
        }
        TextFile tx = new TextFile(stdio);
        String head = tx.head(halfMaxSize);
        String tail = tx.fastTail(halfMaxSize);
        int headBytes = head.getBytes().length;
        middle = len - (long)(headBytes + (tailBytes = tail.getBytes().length));
        if (middle <= 0L) {
            return FileUtils.readFileToString((File)stdio);
        }
        return head + "\n...[truncated " + middle + " bytes]...\n" + tail;
    }

    private static int halfMaxSize(Collection<CaseResult> results) {
        for (CaseResult result : results) {
            if (result.errorStackTrace == null) continue;
            return 50000;
        }
        return 500;
    }

    public CaseResult(SuiteResult parent, String testName, String errorStackTrace) {
        this.className = parent == null ? "unnamed" : parent.getName();
        this.testName = testName;
        this.errorStackTrace = errorStackTrace;
        this.errorDetails = "";
        this.parent = parent;
        this.stdout = null;
        this.stderr = null;
        this.duration = 0.0f;
        this.skipped = false;
        this.skippedMessage = null;
    }

    @Override
    public ClassResult getParent() {
        return this.classResult;
    }

    private static String getError(Element testCase) {
        String msg = testCase.elementText("error");
        if (msg != null) {
            return msg;
        }
        return testCase.elementText("failure");
    }

    private static String getErrorMessage(Element testCase) {
        Element msg = testCase.element("error");
        if (msg == null) {
            msg = testCase.element("failure");
        }
        if (msg == null) {
            return null;
        }
        return msg.attributeValue("message");
    }

    private static boolean isMarkedAsSkipped(Element testCase) {
        return testCase.element("skipped") != null;
    }

    private static String getSkippedMessage(Element testCase) {
        String message = null;
        Element skippedElement = testCase.element("skipped");
        if (skippedElement != null) {
            message = skippedElement.attributeValue("message");
        }
        return message;
    }

    public String getDisplayName() {
        return TestNameTransformer.getTransformedName(this.testName);
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        return this.testName;
    }

    @Override
    public String getTitle() {
        return "Case Result: " + this.getDisplayName();
    }

    @Override
    @Exported(visibility=9)
    public float getDuration() {
        return this.duration;
    }

    @Override
    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        StringBuilder buf = new StringBuilder(this.testName);
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            buf.setCharAt(i, '_');
        }
        List siblings = this.classResult == null ? Collections.emptyList() : this.classResult.getChildren();
        this.safeName = this.uniquifyName(siblings, buf.toString());
        return this.safeName;
    }

    @Exported(visibility=9)
    public String getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        int idx = this.className.lastIndexOf(46);
        return this.className.substring(idx + 1);
    }

    public String getPackageName() {
        int idx = this.className.lastIndexOf(46);
        if (idx < 0) {
            return "(root)";
        }
        return this.className.substring(0, idx);
    }

    @Override
    public String getFullName() {
        return this.className + '.' + this.getName();
    }

    @Override
    public String getFullDisplayName() {
        return TestNameTransformer.getTransformedName(this.getFullName());
    }

    @Override
    public int getFailCount() {
        if (this.isFailed()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getSkipCount() {
        if (this.isSkipped()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPassCount() {
        return this.isPassed() ? 1 : 0;
    }

    @Override
    @Exported(visibility=9)
    public int getFailedSince() {
        if (this.failedSince == 0 && this.getFailCount() == 1) {
            CaseResult prev = this.getPreviousResult();
            if (prev != null && !prev.isPassed()) {
                this.failedSince = prev.getFailedSince();
            } else if (this.getRun() != null) {
                this.failedSince = this.getRun().getNumber();
            } else {
                LOGGER.warning("trouble calculating getFailedSince. We've got prev, but no owner.");
            }
        }
        return this.failedSince;
    }

    @Override
    public Run<?, ?> getFailedSinceRun() {
        return this.getRun().getParent().getBuildByNumber(this.getFailedSince());
    }

    @Exported(visibility=9)
    public int getAge() {
        if (this.isPassed()) {
            return 0;
        }
        if (this.getRun() != null) {
            return this.getRun().getNumber() - this.getFailedSince() + 1;
        }
        LOGGER.fine("Trying to get age of a CaseResult without an owner");
        return 0;
    }

    @Override
    @Exported
    public String getStdout() {
        if (this.stdout != null) {
            return this.stdout;
        }
        SuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            return "";
        }
        return this.getSuiteResult().getStdout();
    }

    @Override
    @Exported
    public String getStderr() {
        if (this.stderr != null) {
            return this.stderr;
        }
        SuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            return "";
        }
        return this.getSuiteResult().getStderr();
    }

    @Override
    public CaseResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        SuiteResult pr = this.parent.getPreviousResult();
        if (pr == null) {
            return null;
        }
        return pr.getCase(this.getName());
    }

    @Override
    public hudson.tasks.test.TestResult findCorrespondingResult(String id) {
        if (id.equals(CaseResult.safe(this.getName()))) {
            return this;
        }
        return null;
    }

    @Override
    public Collection<? extends hudson.tasks.test.TestResult> getFailedTests() {
        return this.singletonListOfThisOrEmptyList(this.isFailed());
    }

    @Override
    public Collection<? extends hudson.tasks.test.TestResult> getPassedTests() {
        return this.singletonListOfThisOrEmptyList(this.isPassed());
    }

    @Override
    public Collection<? extends hudson.tasks.test.TestResult> getSkippedTests() {
        return this.singletonListOfThisOrEmptyList(this.isSkipped());
    }

    private Collection<? extends hudson.tasks.test.TestResult> singletonListOfThisOrEmptyList(boolean f) {
        if (f) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    @Override
    @Exported
    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    @Override
    @Exported
    public String getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public boolean isPassed() {
        return !this.skipped && this.errorStackTrace == null;
    }

    @Exported(visibility=9)
    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isFailed() {
        return !this.isPassed() && !this.isSkipped();
    }

    @Exported
    public String getSkippedMessage() {
        return this.skippedMessage;
    }

    public SuiteResult getSuiteResult() {
        return this.parent;
    }

    @Override
    public Run<?, ?> getRun() {
        SuiteResult sr = this.getSuiteResult();
        if (sr == null) {
            LOGGER.warning("In getOwner(), getSuiteResult is null");
            return null;
        }
        TestResult tr = sr.getParent();
        if (tr == null) {
            LOGGER.warning("In getOwner(), suiteResult.getParent() is null.");
            return null;
        }
        return tr.getRun();
    }

    public void setParentSuiteResult(SuiteResult parent) {
        this.parent = parent;
    }

    public void freeze(SuiteResult parent) {
        this.parent = parent;
        if (!this.isPassed() && this.failedSince == 0) {
            CaseResult prev = this.getPreviousResult();
            this.failedSince = prev != null && !prev.isPassed() ? prev.failedSince : this.getRun().getNumber();
        }
    }

    @Override
    public int compareTo(CaseResult that) {
        if (this == that) {
            return 0;
        }
        int r = this.getFullName().compareTo(that.getFullName());
        if (r != 0) {
            return r;
        }
        return System.identityHashCode(this) >= System.identityHashCode(that) ? 1 : -1;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Exported(name="status", visibility=9)
    public Status getStatus() {
        if (this.skipped) {
            return Status.SKIPPED;
        }
        CaseResult pr = this.getPreviousResult();
        if (pr == null) {
            return this.isPassed() ? Status.PASSED : Status.FAILED;
        }
        if (pr.isPassed()) {
            return this.isPassed() ? Status.PASSED : Status.REGRESSION;
        }
        return this.isPassed() ? Status.FIXED : Status.FAILED;
    }

    void setClass(ClassResult classResult) {
        this.classResult = classResult;
    }

    void replaceParent(SuiteResult parent) {
        this.parent = parent;
    }

    public static enum Status {
        PASSED("result-passed", Messages._CaseResult_Status_Passed(), true),
        SKIPPED("result-skipped", Messages._CaseResult_Status_Skipped(), false),
        FAILED("result-failed", Messages._CaseResult_Status_Failed(), false),
        FIXED("result-fixed", Messages._CaseResult_Status_Fixed(), true),
        REGRESSION("result-regression", Messages._CaseResult_Status_Regression(), false);

        private final String cssClass;
        private final Localizable message;
        public final boolean isOK;

        private Status(String cssClass, Localizable message, boolean OK) {
            this.cssClass = cssClass;
            this.message = message;
            this.isOK = OK;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getMessage() {
            return this.message.toString();
        }

        public boolean isRegression() {
            return this == REGRESSION;
        }
    }
}

