/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook.subscriber;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Job;
import java.util.Set;
import javax.inject.Inject;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.github.admin.GitHubHookRegisterProblemMonitor;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.kohsuke.github.GHEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PingGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingGHEventSubscriber.class);
    @Inject
    private transient GitHubHookRegisterProblemMonitor monitor;

    @Override
    protected boolean isApplicable(Job<?, ?> project) {
        return false;
    }

    @Override
    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PING, (Enum[])new GHEvent[0]);
    }

    @Override
    protected void onEvent(GHEvent event, String payload) {
        JSONObject parsedPayload = JSONObject.fromObject((Object)payload);
        JSONObject repository = parsedPayload.optJSONObject("repository");
        if (repository != null) {
            LOGGER.info("{} webhook received from repo <{}>!", (Object)event, (Object)repository.getString("html_url"));
            this.monitor.resolveProblem(GitHubRepositoryName.create(repository.getString("html_url")));
        } else {
            JSONObject organization = parsedPayload.optJSONObject("organization");
            if (organization != null) {
                LOGGER.info("{} webhook received from org <{}>!", (Object)event, (Object)organization.getString("url"));
            } else {
                LOGGER.warn("{} webhook received with unexpected payload", (Object)event);
            }
        }
    }
}

