/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook.subscriber;

import com.cloudbees.jenkins.GitHubPushTrigger;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.cloudbees.jenkins.GitHubTrigger;
import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Job;
import hudson.security.ACL;
import java.util.Set;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.github.GHEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DefaultPushGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPushGHEventSubscriber.class);

    @Override
    protected boolean isApplicable(Job<?, ?> project) {
        return JobInfoHelpers.withTrigger(GitHubPushTrigger.class).apply(project);
    }

    @Override
    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PUSH, (Enum[])new GHEvent[0]);
    }

    @Override
    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        String repoUrl = json.getJSONObject("repository").getString("url");
        final String pusherName = json.getJSONObject("pusher").getString("name");
        LOGGER.info("Received POST for {}", (Object)repoUrl);
        final GitHubRepositoryName changedRepository = GitHubRepositoryName.create(repoUrl);
        if (changedRepository != null) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Job job : Jenkins.getInstance().getAllItems(Job.class)) {
                        GitHubTrigger trigger = JobInfoHelpers.triggerFrom(job, GitHubPushTrigger.class);
                        if (trigger == null) continue;
                        LOGGER.debug("Considering to poke {}", (Object)job.getFullDisplayName());
                        if (GitHubRepositoryNameContributor.parseAssociatedNames(job).contains(changedRepository)) {
                            LOGGER.info("Poked {}", (Object)job.getFullDisplayName());
                            trigger.onPost(pusherName);
                            continue;
                        }
                        LOGGER.debug("Skipped {} because it doesn't have a matching repository.", (Object)job.getFullDisplayName());
                    }
                }
            });
            for (GitHubWebHook.Listener listener : Jenkins.getInstance().getExtensionList(GitHubWebHook.Listener.class)) {
                listener.onPushRepositoryChanged(pusherName, changedRepository);
            }
        } else {
            LOGGER.warn("Malformed repo url {}", (Object)repoUrl);
        }
    }
}

