/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.util;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import hudson.model.Job;
import hudson.triggers.Trigger;
import java.util.Collection;
import javax.annotation.CheckForNull;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;

public final class JobInfoHelpers {
    private JobInfoHelpers() {
        throw new IllegalAccessError("Do not instantiate it");
    }

    public static Predicate<Job> withTrigger(final Class<? extends Trigger> clazz) {
        return new Predicate<Job>(){

            public boolean apply(Job job) {
                return JobInfoHelpers.triggerFrom(job, clazz) != null;
            }
        };
    }

    public static Predicate<Job> isBuildable() {
        return new Predicate<Job>(){

            public boolean apply(Job job) {
                return job != null && job.isBuildable();
            }
        };
    }

    public static Function<Job, Collection<GitHubRepositoryName>> associatedNames() {
        return new Function<Job, Collection<GitHubRepositoryName>>(){

            public Collection<GitHubRepositoryName> apply(Job job) {
                return GitHubRepositoryNameContributor.parseAssociatedNames(job);
            }
        };
    }

    public static Predicate<Job> isAlive() {
        return new Predicate<Job>(){

            public boolean apply(Job job) {
                return !FluentIterableWrapper.from(GHEventsSubscriber.all()).filter(GHEventsSubscriber.isApplicableFor(job)).toList().isEmpty();
            }
        };
    }

    @CheckForNull
    public static <T extends Trigger> T triggerFrom(Job<?, ?> job, Class<T> tClass) {
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
            for (Trigger candidate : pJob.getTriggers().values()) {
                if (!tClass.isInstance(candidate)) continue;
                return (T)((Trigger)tClass.cast(candidate));
            }
        }
        return null;
    }

    public static <T extends Job> ParameterizedJobMixIn asParameterizedJobMixIn(final T job) {
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        };
    }
}

