/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.github.extension.status.GitHubReposSource;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;

public class ManuallyEnteredRepositorySource
extends GitHubReposSource {
    private String url;

    @DataBoundConstructor
    public ManuallyEnteredRepositorySource(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    @VisibleForTesting
    GitHubRepositoryName createName(String url) {
        return GitHubRepositoryName.create(url);
    }

    @Override
    public List<GHRepository> repos(@Nonnull Run<?, ?> run, final @Nonnull TaskListener listener) {
        List<String> urls = Collections.singletonList(this.url);
        return FluentIterableWrapper.from(urls).transformAndConcat(new NullSafeFunction<String, Iterable<GHRepository>>(){

            @Override
            protected Iterable<GHRepository> applyNullSafe(@Nonnull String url) {
                GitHubRepositoryName name = ManuallyEnteredRepositorySource.this.createName(url);
                if (name != null) {
                    return name.resolve();
                }
                listener.getLogger().printf("Unable to match %s with a GitHub repository.%n", url);
                return Collections.emptyList();
            }
        }).toList();
    }

    @Extension
    public static class ManuallyEnteredRepositorySourceDescriptor
    extends Descriptor<GitHubReposSource> {
        public String getDisplayName() {
            return "Manually entered repository";
        }
    }
}

