/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.github.common.ExpandableMessage;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusBackrefSource;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManuallyEnteredBackrefSource
extends GitHubStatusBackrefSource {
    private static final Logger LOG = LoggerFactory.getLogger(ManuallyEnteredBackrefSource.class);
    private String backref;

    @DataBoundConstructor
    public ManuallyEnteredBackrefSource(String backref) {
        this.backref = backref;
    }

    public String getBackref() {
        return this.backref;
    }

    @Override
    public String get(Run<?, ?> run, TaskListener listener) {
        try {
            return new ExpandableMessage(this.backref).expandAll(run, listener);
        }
        catch (Exception e) {
            LOG.debug("Can't expand backref, returning as is", (Throwable)e);
            return this.backref;
        }
    }

    @Extension
    public static class ManuallyEnteredBackrefSourceDescriptor
    extends Descriptor<GitHubStatusBackrefSource> {
        public String getDisplayName() {
            return "Manually entered backref";
        }
    }
}

