/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.internal;

import com.cloudbees.jenkins.GitHubWebHook;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.internal.GitHubClientCacheOps;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public class GitHubLoginFunction
extends NullSafeFunction<GitHubServerConfig, GitHub> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubLoginFunction.class);

    @Override
    @CheckForNull
    protected GitHub applyNullSafe(@Nonnull GitHubServerConfig github) {
        String accessToken = GitHubServerConfig.tokenFor(github.getCredentialsId());
        GitHubBuilder builder = new GitHubBuilder().withOAuthToken(accessToken).withConnector((HttpConnector)this.connector(github)).withRateLimitHandler(RateLimitHandler.FAIL);
        try {
            if (StringUtils.isNotBlank((CharSequence)github.getApiUrl())) {
                builder.withEndpoint(github.getApiUrl());
            }
            LOGGER.debug("Create new GH client with creds id {}", (Object)github.getCredentialsId());
            return builder.build();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to login with creds {}", (Object)github.getCredentialsId(), (Object)e);
            return null;
        }
    }

    @Nonnull
    private Proxy getProxy(String apiUrl) {
        Jenkins jenkins = GitHubWebHook.getJenkinsInstance();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        try {
            return jenkins.proxy.createProxy(new URL(apiUrl).getHost());
        }
        catch (MalformedURLException e) {
            return jenkins.proxy.createProxy(apiUrl);
        }
    }

    private OkHttpConnector connector(GitHubServerConfig config) {
        OkHttpClient client = new OkHttpClient().setProxy(this.getProxy((String)StringUtils.defaultIfBlank((CharSequence)config.getApiUrl(), (CharSequence)"https://api.github.com")));
        if (config.getClientCacheSize() > 0) {
            Cache cache = (Cache)GitHubClientCacheOps.toCacheDir().apply((Object)config);
            client.setCache(cache);
        }
        return new OkHttpConnector(new OkUrlFactory(client));
    }

    private static class OkHttpConnector
    implements HttpConnector {
        private final OkUrlFactory urlFactory;

        private OkHttpConnector(OkUrlFactory urlFactory) {
            this.urlFactory = urlFactory;
        }

        public HttpURLConnection connect(URL url) throws IOException {
            return this.urlFactory.open(url);
        }
    }
}

