/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.extension;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Job;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.ObjectUtils;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.jenkinsci.plugins.github.util.misc.NullSafePredicate;
import org.kohsuke.github.GHEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GHEventsSubscriber
implements ExtensionPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHEventsSubscriber.class);

    protected abstract boolean isApplicable(@Nullable Job<?, ?> var1);

    protected abstract Set<GHEvent> events();

    protected void onEvent(GHEvent event, String payload) {
    }

    public static ExtensionList<GHEventsSubscriber> all() {
        return Jenkins.getInstance().getExtensionList(GHEventsSubscriber.class);
    }

    public static Function<GHEventsSubscriber, Set<GHEvent>> extractEvents() {
        return new NullSafeFunction<GHEventsSubscriber, Set<GHEvent>>(){

            @Override
            protected Set<GHEvent> applyNullSafe(@Nonnull GHEventsSubscriber subscriber) {
                return (Set)ObjectUtils.defaultIfNull(subscriber.events(), Collections.emptySet());
            }
        };
    }

    public static Predicate<GHEventsSubscriber> isApplicableFor(final Job<?, ?> project) {
        return new NullSafePredicate<GHEventsSubscriber>(){

            @Override
            protected boolean applyNullSafe(@Nonnull GHEventsSubscriber subscriber) {
                return subscriber.isApplicable(project);
            }
        };
    }

    public static Predicate<GHEventsSubscriber> isInterestedIn(final GHEvent event) {
        return new NullSafePredicate<GHEventsSubscriber>(){

            @Override
            protected boolean applyNullSafe(@Nonnull GHEventsSubscriber subscriber) {
                return ((Set)ObjectUtils.defaultIfNull(subscriber.events(), Collections.emptySet())).contains(event);
            }
        };
    }

    public static Function<GHEventsSubscriber, Void> processEvent(final GHEvent event, final String payload) {
        return new NullSafeFunction<GHEventsSubscriber, Void>(){

            @Override
            protected Void applyNullSafe(@Nonnull GHEventsSubscriber subscriber) {
                try {
                    subscriber.onEvent(event, payload);
                }
                catch (Throwable t) {
                    LOGGER.error("Subscriber {} failed to process {} hook, skipping...", new Object[]{subscriber.getClass().getName(), event, t});
                }
                return null;
            }
        };
    }
}

