/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.config;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class HookSecretConfig
extends AbstractDescribableImpl<HookSecretConfig> {
    private String credentialsId;

    @DataBoundConstructor
    public HookSecretConfig(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Nullable
    public Secret getHookSecret() {
        return (Secret)GitHubServerConfig.secretFor(this.credentialsId).orNull();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HookSecretConfig> {
        public String getDisplayName() {
            return "Hook secret configuration";
        }

        public ListBoxModel doFillCredentialsIdItems() {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }
    }
}

