/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.common;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.Messages;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandableMessage
extends AbstractDescribableImpl<ExpandableMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpandableMessage.class);
    private final String content;

    @DataBoundConstructor
    public ExpandableMessage(String content) {
        this.content = content;
    }

    public String expandAll(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        if (run instanceof AbstractBuild) {
            try {
                return TokenMacro.expandAll((AbstractBuild)((AbstractBuild)run), (TaskListener)listener, (String)this.content, (boolean)false, Collections.emptyList());
            }
            catch (MacroEvaluationException e) {
                LOGGER.error("Can't process token content {} in {} ({})", new Object[]{this.content, run.getParent().getFullName(), e.getMessage()});
                LOGGER.trace(e.getMessage(), (Throwable)e);
                return this.content;
            }
        }
        return run.getEnvironment(listener).expand(StringUtils.trimToEmpty((String)this.content));
    }

    public String getContent() {
        return this.content;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExpandableMessage> {
        public String getDisplayName() {
            return Messages.common_expandable_message_title();
        }
    }
}

