/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import com.cloudbees.jenkins.GitHubPushTrigger;
import com.coravy.hudson.plugins.github.GithubUrl;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public final class GithubProjectProperty
extends JobProperty<Job<?, ?>> {
    private String projectUrl;
    private String displayName;
    private static final Logger LOGGER = Logger.getLogger(GitHubPushTrigger.class.getName());

    @DataBoundConstructor
    public GithubProjectProperty(String projectUrlStr) {
        this.projectUrl = new GithubUrl(projectUrlStr).baseUrl();
    }

    public String getProjectUrlStr() {
        return this.projectUrl;
    }

    public GithubUrl getProjectUrl() {
        return new GithubUrl(this.projectUrl);
    }

    @CheckForNull
    public String getDisplayName() {
        return this.displayName;
    }

    @DataBoundSetter
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static String displayNameFor(@Nonnull Job<?, ?> job) {
        GithubProjectProperty ghProp = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
        if (ghProp != null && StringUtils.isNotBlank((CharSequence)ghProp.getDisplayName())) {
            return ghProp.getDisplayName();
        }
        return job.getFullName();
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public static final String GITHUB_PROJECT_BLOCK_NAME = "githubProject";

        public boolean isApplicable(Class<? extends Job> jobType) {
            return ParameterizedJobMixIn.ParameterizedJob.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "GitHub project page";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            GithubProjectProperty tpp = (GithubProjectProperty)((Object)req.bindJSON(GithubProjectProperty.class, formData.getJSONObject(GITHUB_PROJECT_BLOCK_NAME)));
            if (tpp == null) {
                LOGGER.fine("Couldn't bind JSON");
                return null;
            }
            if (tpp.projectUrl == null) {
                LOGGER.fine("projectUrl not found, nullifying GithubProjectProperty");
                return null;
            }
            return tpp;
        }
    }
}

