/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.github.util.XSSApi;

public final class GithubLinkAction
implements Action {
    private final transient GithubProjectProperty projectProperty;

    public GithubLinkAction(GithubProjectProperty githubProjectProperty) {
        this.projectProperty = githubProjectProperty;
    }

    public String getDisplayName() {
        return "GitHub";
    }

    public String getIconFileName() {
        return "/plugin/github/logov3.png";
    }

    public String getUrlName() {
        return XSSApi.asValidHref(this.projectProperty.getProjectUrl().baseUrl());
    }

    @Extension
    public static class GithubLinkActionFactory
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        public Collection<? extends Action> createFor(Job j) {
            GithubProjectProperty prop = (GithubProjectProperty)j.getProperty(GithubProjectProperty.class);
            if (prop == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(new GithubLinkAction(prop));
        }
    }
}

