/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

import com.cloudbees.jenkins.Cleaner;
import com.cloudbees.jenkins.Credential;
import com.cloudbees.jenkins.GitHubPushCause;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.cloudbees.jenkins.GitHubTrigger;
import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.NamingThreadFactory;
import hudson.util.SequentialExecutionQueue;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.Messages;
import org.jenkinsci.plugins.github.admin.GitHubHookRegisterProblemMonitor;
import org.jenkinsci.plugins.github.internal.GHPluginConfigException;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubPushTrigger
extends Trigger<Job<?, ?>>
implements GitHubTrigger {
    public static final boolean ALLOW_HOOKURL_OVERRIDE = !Boolean.getBoolean(GitHubPushTrigger.class.getName() + ".disableOverride");
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPushTrigger.class);

    @DataBoundConstructor
    public GitHubPushTrigger() {
    }

    @Override
    @Deprecated
    public void onPost() {
        this.onPost("");
    }

    @Override
    public void onPost(String triggeredByUser) {
        final String pushBy = triggeredByUser;
        DescriptorImpl d = this.getDescriptor();
        d.checkThreadPoolSizeAndUpdateIfNecessary();
        d.queue.execute(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean runPolling() {
                try (StreamTaskListener listener = new StreamTaskListener(GitHubPushTrigger.this.getLogFile());){
                    PrintStream logger = listener.getLogger();
                    long start = System.currentTimeMillis();
                    logger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
                    boolean result = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)GitHubPushTrigger.this.job).poll((TaskListener)listener).hasChanges();
                    logger.println("Done. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)));
                    if (result) {
                        logger.println("Changes found");
                    } else {
                        logger.println("No changes");
                    }
                    boolean bl = result;
                    return bl;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to record SCM polling", (Throwable)e);
                    return false;
                }
            }

            @Override
            public void run() {
                if (this.runPolling()) {
                    GitHubPushCause cause;
                    try {
                        cause = new GitHubPushCause(GitHubPushTrigger.this.getLogFile(), pushBy);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to parse the polling log", (Throwable)e);
                        cause = new GitHubPushCause(pushBy);
                    }
                    if (JobInfoHelpers.asParameterizedJobMixIn((Job)GitHubPushTrigger.this.job).scheduleBuild((Cause)cause)) {
                        LOGGER.info("SCM changes detected in " + ((Job)GitHubPushTrigger.this.job).getFullName() + ". Triggering #" + ((Job)GitHubPushTrigger.this.job).getNextBuildNumber());
                    } else {
                        LOGGER.info("SCM changes detected in " + ((Job)GitHubPushTrigger.this.job).getFullName() + ". Job is already in the queue");
                    }
                }
            }
        });
    }

    public File getLogFile() {
        return new File(((Job)this.job).getRootDir(), "github-polling.log");
    }

    @Override
    @Deprecated
    public Set<GitHubRepositoryName> getGitHubRepositories() {
        return Collections.emptySet();
    }

    public void start(Job<?, ?> project, boolean newInstance) {
        super.start(project, newInstance);
        if (newInstance && GitHubPlugin.configuration().isManageHooks()) {
            this.registerHooks();
        }
    }

    public void registerHooks() {
        GitHubWebHook.get().registerHookFor((Job)this.job);
    }

    public void stop() {
        Cleaner cleaner;
        if (this.job == null) {
            return;
        }
        if (GitHubPlugin.configuration().isManageHooks() && (cleaner = Cleaner.get()) != null) {
            cleaner.onStop((Job)this.job);
        }
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.job == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(new GitHubWebHookPollingAction());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Executors.newSingleThreadExecutor(DescriptorImpl.threadFactory()));
        private transient String hookUrl;
        private transient List<Credential> credentials;
        @Inject
        private transient GitHubHookRegisterProblemMonitor monitor;
        @Inject
        private transient SCMTrigger.DescriptorImpl scmTrigger;
        private transient int maximumThreads = Integer.MIN_VALUE;

        public DescriptorImpl() {
            this.checkThreadPoolSizeAndUpdateIfNecessary();
        }

        synchronized void checkThreadPoolSizeAndUpdateIfNecessary() {
            int count;
            if (this.scmTrigger != null && this.maximumThreads != (count = this.scmTrigger.getPollingThreadCount())) {
                this.maximumThreads = count;
                this.queue.setExecutors(count == 0 ? Executors.newCachedThreadPool(DescriptorImpl.threadFactory()) : Executors.newFixedThreadPool(this.maximumThreads, DescriptorImpl.threadFactory()));
            }
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job && SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item) != null && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public String getDisplayName() {
            return "Build when a change is pushed to GitHub";
        }

        @Deprecated
        public boolean isManageHook() {
            return GitHubPlugin.configuration().isManageHooks();
        }

        @Deprecated
        public URL getHookUrl() throws GHPluginConfigException {
            return GitHubPlugin.configuration().getHookUrl();
        }

        @Deprecated
        public List<Credential> getCredentials() {
            return this.credentials;
        }

        @Deprecated
        public URL getDeprecatedHookUrl() {
            if (StringUtils.isEmpty((CharSequence)this.hookUrl)) {
                return null;
            }
            try {
                return new URL(this.hookUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Malformed hook url skipped while migration ({})", (Object)e.getMessage());
                return null;
            }
        }

        public void clearDeprecatedHookUrl() {
            this.hookUrl = null;
        }

        public void clearCredentials() {
            this.credentials = null;
        }

        @Deprecated
        public boolean hasOverrideURL() {
            return GitHubPlugin.configuration().isOverrideHookURL();
        }

        protected XmlFile getConfigFile() {
            return new XmlFile((XStream)Jenkins.XSTREAM2, super.getConfigFile().getFile());
        }

        public static DescriptorImpl get() {
            return (DescriptorImpl)((Object)Trigger.all().get(DescriptorImpl.class));
        }

        public static boolean allowsHookUrlOverride() {
            return ALLOW_HOOKURL_OVERRIDE;
        }

        private static ThreadFactory threadFactory() {
            return new NamingThreadFactory(Executors.defaultThreadFactory(), "GitHubPushTrigger");
        }

        public FormValidation doCheckHookRegistered(@AncestorInPath Job<?, ?> job) {
            Preconditions.checkNotNull(job, (Object)"Job can't be null if wants to check hook in monitor");
            Collection<GitHubRepositoryName> repos = GitHubRepositoryNameContributor.parseAssociatedNames(job);
            for (GitHubRepositoryName repo : repos) {
                if (!this.monitor.isProblemWith(repo)) continue;
                return FormValidation.warning((String)Messages.github_trigger_check_method_warning_details(repo.getUserName(), repo.getRepositoryName(), repo.getHost()));
            }
            return FormValidation.ok();
        }
    }

    public final class GitHubWebHookPollingAction
    implements Action {
        public Job<?, ?> getOwner() {
            return (Job)GitHubPushTrigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "GitHub Hook Log";
        }

        public String getUrlName() {
            return "GitHubPollLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)GitHubPushTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(GitHubPushTrigger.this.getLogFile(), Charsets.UTF_8, true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }
}

