/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.spi.db;

import com.sun.xml.internal.ws.spi.db.BindingContext;
import com.sun.xml.internal.ws.spi.db.TypeInfo;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class RepeatedElementBridge<T>
implements XMLBridge<T> {
    XMLBridge<T> delegate;
    CollectionHandler collectionHandler;
    static final CollectionHandler ListHandler = new BaseCollectionHandler(List.class){

        @Override
        public Object convert(List list) {
            return list;
        }
    };
    static final CollectionHandler HashSetHandler = new BaseCollectionHandler(HashSet.class){

        @Override
        public Object convert(List list) {
            return new HashSet(list);
        }
    };

    public RepeatedElementBridge(TypeInfo typeInfo, XMLBridge xMLBridge) {
        this.delegate = xMLBridge;
        this.collectionHandler = RepeatedElementBridge.create(typeInfo);
    }

    public CollectionHandler collectionHandler() {
        return this.collectionHandler;
    }

    @Override
    public BindingContext context() {
        return this.delegate.context();
    }

    @Override
    public void marshal(T t, XMLStreamWriter xMLStreamWriter, AttachmentMarshaller attachmentMarshaller) throws JAXBException {
        this.delegate.marshal(t, xMLStreamWriter, attachmentMarshaller);
    }

    @Override
    public void marshal(T t, OutputStream outputStream, NamespaceContext namespaceContext, AttachmentMarshaller attachmentMarshaller) throws JAXBException {
        this.delegate.marshal(t, outputStream, namespaceContext, attachmentMarshaller);
    }

    @Override
    public void marshal(T t, Node node) throws JAXBException {
        this.delegate.marshal(t, node);
    }

    @Override
    public void marshal(T t, ContentHandler contentHandler, AttachmentMarshaller attachmentMarshaller) throws JAXBException {
        this.delegate.marshal(t, contentHandler, attachmentMarshaller);
    }

    @Override
    public void marshal(T t, Result result) throws JAXBException {
        this.delegate.marshal(t, result);
    }

    @Override
    public T unmarshal(XMLStreamReader xMLStreamReader, AttachmentUnmarshaller attachmentUnmarshaller) throws JAXBException {
        return this.delegate.unmarshal(xMLStreamReader, attachmentUnmarshaller);
    }

    @Override
    public T unmarshal(Source source, AttachmentUnmarshaller attachmentUnmarshaller) throws JAXBException {
        return this.delegate.unmarshal(source, attachmentUnmarshaller);
    }

    @Override
    public T unmarshal(InputStream inputStream) throws JAXBException {
        return this.delegate.unmarshal(inputStream);
    }

    @Override
    public T unmarshal(Node node, AttachmentUnmarshaller attachmentUnmarshaller) throws JAXBException {
        return this.delegate.unmarshal(node, attachmentUnmarshaller);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.delegate.getTypeInfo();
    }

    @Override
    public boolean supportOutputStream() {
        return this.delegate.supportOutputStream();
    }

    public static CollectionHandler create(TypeInfo typeInfo) {
        Class clazz = (Class)typeInfo.type;
        if (clazz.isArray()) {
            return new ArrayHandler((Class)typeInfo.getItemType().type);
        }
        if (List.class.equals((Object)clazz) || Collection.class.equals((Object)clazz)) {
            return ListHandler;
        }
        if (Set.class.equals((Object)clazz) || HashSet.class.equals((Object)clazz)) {
            return HashSetHandler;
        }
        return new BaseCollectionHandler(clazz);
    }

    static class ArrayHandler
    implements CollectionHandler {
        Class componentClass;

        public ArrayHandler(Class clazz) {
            this.componentClass = clazz;
        }

        @Override
        public int getSize(Object object) {
            return Array.getLength(object);
        }

        @Override
        public Object convert(List list) {
            Object object = Array.newInstance(this.componentClass, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(object, i, list.get(i));
            }
            return object;
        }

        @Override
        public Iterator iterator(final Object object) {
            return new Iterator(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    if (object == null || Array.getLength(object) == 0) {
                        return false;
                    }
                    return this.index != Array.getLength(object);
                }

                public Object next() throws NoSuchElementException {
                    Object object2 = null;
                    try {
                        object2 = Array.get(object, this.index++);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new NoSuchElementException();
                    }
                    return object2;
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    static class BaseCollectionHandler
    implements CollectionHandler {
        Class type;

        BaseCollectionHandler(Class clazz) {
            this.type = clazz;
        }

        @Override
        public int getSize(Object object) {
            return ((Collection)object).size();
        }

        @Override
        public Object convert(List list) {
            try {
                Object t = this.type.newInstance();
                ((Collection)t).addAll(list);
                return t;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return list;
            }
        }

        @Override
        public Iterator iterator(Object object) {
            return ((Collection)object).iterator();
        }
    }

    public static interface CollectionHandler {
        public int getSize(Object var1);

        public Iterator iterator(Object var1);

        public Object convert(List var1);
    }
}

