/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.jenkinsci.remoting.engine.ChannelCiphers;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.HandshakeCiphers;
import org.jenkinsci.remoting.engine.Jnlp3Util;
import org.jenkinsci.remoting.engine.JnlpProtocol;

class JnlpProtocol3
extends JnlpProtocol {
    private String cookie;
    private ChannelCiphers channelCiphers;
    public static final String CHALLENGE_KEY = "Challenge";
    public static final String COOKIE_KEY = "Cookie";
    public static final String NAME = "JNLP3-connect";
    public static final String SLAVE_NAME_KEY = "Node-Name";
    static final String NEGOTIATE_LINE = "Negotiate";

    JnlpProtocol3(String slaveName, String slaveSecret, EngineListener events) {
        super(slaveName, slaveSecret, events);
    }

    @Override
    public String getName() {
        return NAME;
    }

    String getCookie() {
        return this.cookie;
    }

    ChannelCiphers getChannelCiphers() {
        return this.channelCiphers;
    }

    @Override
    boolean performHandshake(DataOutputStream outputStream, BufferedInputStream inputStream) throws IOException {
        HandshakeCiphers handshakeCiphers = HandshakeCiphers.create(this.slaveName, this.slaveSecret);
        if (!this.initiateAndValidateMaster(inputStream, outputStream, handshakeCiphers)) {
            return false;
        }
        if (!this.authenticateToMaster(inputStream, outputStream, handshakeCiphers)) {
            return false;
        }
        this.channelCiphers = ChannelCiphers.create();
        outputStream.writeUTF(handshakeCiphers.encrypt(Jnlp3Util.keyToString(this.channelCiphers.getAesKey())));
        outputStream.writeUTF(handshakeCiphers.encrypt(Jnlp3Util.keyToString(this.channelCiphers.getSpecKey())));
        return true;
    }

    @Override
    Channel buildChannel(Socket socket, ChannelBuilder channelBuilder, BufferedInputStream inputStream) throws IOException {
        return channelBuilder.build(new CipherInputStream(inputStream, this.channelCiphers.getDecryptCipher()), new CipherOutputStream(socket.getOutputStream(), this.channelCiphers.getEncryptCipher()));
    }

    private boolean initiateAndValidateMaster(BufferedInputStream inputStream, DataOutputStream outputStream, HandshakeCiphers handshakeCiphers) throws IOException {
        String challenge = Jnlp3Util.generateChallenge();
        Properties props = new Properties();
        props.put(SLAVE_NAME_KEY, this.slaveName);
        props.put(CHALLENGE_KEY, handshakeCiphers.encrypt(challenge));
        if (this.cookie != null) {
            props.put(COOKIE_KEY, handshakeCiphers.encrypt(this.cookie));
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        props.store(o, null);
        outputStream.writeUTF("Protocol:JNLP3-connect");
        outputStream.writeUTF(o.toString("UTF-8"));
        String protocolUnderstoodResponse = EngineUtil.readLine(inputStream);
        if (!protocolUnderstoodResponse.equals(NEGOTIATE_LINE)) {
            this.events.status("Server didn't accept the handshake: " + protocolUnderstoodResponse);
            return false;
        }
        Integer challengeResponseLength = Integer.parseInt(EngineUtil.readLine(inputStream));
        String encryptedChallengeResponse = EngineUtil.readChars(inputStream, challengeResponseLength);
        String challengeResponse = handshakeCiphers.decrypt(encryptedChallengeResponse);
        if (!Jnlp3Util.validateChallengeResponse(challenge, challengeResponse)) {
            this.events.status("JNLP3-connect: Incorrect challenge response from master");
            return false;
        }
        outputStream.writeUTF("Welcome");
        return true;
    }

    private boolean authenticateToMaster(BufferedInputStream inputStream, DataOutputStream outputStream, HandshakeCiphers handshakeCiphers) throws IOException {
        Integer challengeLength = Integer.parseInt(EngineUtil.readLine(inputStream));
        String encryptedChallenge = EngineUtil.readChars(inputStream, challengeLength);
        String masterChallenge = handshakeCiphers.decrypt(encryptedChallenge);
        String challengeResponse = Jnlp3Util.createChallengeResponse(masterChallenge);
        String encryptedChallengeResponse = handshakeCiphers.encrypt(challengeResponse);
        outputStream.writeUTF(encryptedChallengeResponse);
        if (!"Welcome".equals(EngineUtil.readLine(inputStream))) {
            return false;
        }
        this.cookie = handshakeCiphers.decrypt(EngineUtil.readLine(inputStream));
        return true;
    }
}

