/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.annotation.Nullable;

public abstract class JnlpProtocol {
    protected final String slaveName;
    protected final String slaveSecret;
    protected final EngineListener events;
    public static final String GREETING_SUCCESS = "Welcome";
    static final String PROTOCOL_PREFIX = "Protocol:";

    JnlpProtocol(String slaveName, String slaveSecret, EngineListener events) {
        this.slaveName = slaveName;
        this.slaveSecret = slaveSecret;
        this.events = events;
    }

    public boolean isEnabled() {
        return !Boolean.getBoolean(this.getClass().getName() + ".disabled");
    }

    public abstract String getName();

    @Nullable
    public Channel establishChannel(Socket socket, ChannelBuilder channelBuilder) throws IOException {
        BufferedInputStream inputStream;
        DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
        if (this.performHandshake(outputStream, inputStream = new BufferedInputStream(socket.getInputStream()))) {
            return this.buildChannel(socket, channelBuilder, inputStream);
        }
        return null;
    }

    abstract boolean performHandshake(DataOutputStream var1, BufferedInputStream var2) throws IOException;

    abstract Channel buildChannel(Socket var1, ChannelBuilder var2, BufferedInputStream var3) throws IOException;
}

