/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.remoting.Base64;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import hudson.remoting.PingThread;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.StandardOutputStream;
import hudson.remoting.TeeOutputStream;
import hudson.remoting.Util;
import hudson.remoting.jnlp.Main;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SuppressFBWarnings(value={"DM_EXIT"}, justification="This class is runnable. It is eligible to exit in the case of wrong params")
public class Launcher {
    public Channel.Mode mode = Channel.Mode.BINARY;
    @Option(name="-ping")
    public boolean ping = true;
    @Option(name="-slaveLog", usage="create local slave error log")
    public File slaveLog = null;
    @Option(name="-jnlpUrl", usage="instead of talking to the master via stdin/stdout, emulate a JNLP client by making a TCP connection to the master. Connection parameters are obtained by parsing the JNLP file.")
    public URL slaveJnlpURL = null;
    @Option(name="-jnlpCredentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP requests.")
    public String slaveJnlpCredentials = null;
    @Option(name="-secret", metaVar="HEX_SECRET", usage="Slave connection secret to use instead of -jnlpCredentials.")
    public String secret;
    @Option(name="-proxyCredentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP authenticated proxy requests.")
    public String proxyCredentials = null;
    @Option(name="-tcp", usage="instead of talking to the master via stdin/stdout, listens to a random local port, write that port number to the given file, then wait for the master to connect to that port.")
    public File tcpPortFile = null;
    @Option(name="-auth", metaVar="user:pass", usage="If your Jenkins is security-enabled, specify a valid user name and password.")
    public String auth = null;
    @Option(name="-jar-cache", metaVar="DIR", usage="Cache directory that stores jar files sent from the master")
    public File jarCache = new File(System.getProperty("user.home"), ".jenkins/cache/jars");
    public InetSocketAddress connectionTarget = null;
    @Option(name="-noReconnect", usage="Doesn't try to reconnect when a communication fail, and exit instead")
    public boolean noReconnect = false;
    @Option(name="-noKeepAlive", usage="Disable TCP socket keep alive on connection to the master.")
    public boolean noKeepAlive = false;
    public static final String VERSION = Launcher.computeVersion();
    private static final String JENKINS_VERSION_PROP_FILE = "hudson-version.properties";
    private static final String UNKNOWN_JENKINS_VERSION_STR = "?";
    private static final Logger LOGGER = Logger.getLogger(Launcher.class.getName());

    @Option(name="-text", usage="encode communication with the master with base64. Useful for running slave over 8-bit unsafe protocol like telnet")
    public void setTextMode(boolean b) {
        this.mode = b ? Channel.Mode.TEXT : Channel.Mode.BINARY;
        System.out.println("Running in " + this.mode.name().toLowerCase(Locale.ENGLISH) + " mode");
    }

    @Option(name="-cp", aliases={"-classpath"}, metaVar="PATH", usage="add the given classpath elements to the system classloader.")
    public void addClasspath(String pathList) throws Exception {
        Method $addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        $addURL.setAccessible(true);
        for (String token : pathList.split(File.pathSeparator)) {
            $addURL.invoke((Object)ClassLoader.getSystemClassLoader(), new File(token).toURI().toURL());
        }
        System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparatorChar + pathList);
    }

    @Option(name="-connectTo", usage="make a TCP connection to the given host and port, then start communication.", metaVar="HOST:PORT")
    public void setConnectTo(String target) {
        String[] tokens = target.split(":");
        if (tokens.length != 2) {
            System.err.println("Illegal parameter: " + target);
            System.exit(1);
        }
        this.connectionTarget = new InetSocketAddress(tokens[0], Integer.parseInt(tokens[1]));
    }

    @Option(name="-noCertificateCheck")
    public void setNoCertificateCheck(boolean ignored) throws NoSuchAlgorithmException, KeyManagementException {
        System.out.println("Skipping HTTPS certificate checks altogether. Note that this is not secure at all.");
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new NoCheckTrustManager()}, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Launcher launcher = new Launcher();
        CmdLineParser parser = new CmdLineParser(launcher);
        try {
            parser.parseArgument(args);
            launcher.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar slave.jar [options...]");
            parser.printUsage(System.err);
            System.err.println();
        }
    }

    @SuppressWarnings(value={"DM_DEFAULT_ENCODING"})
    public void run() throws Exception {
        if (this.slaveLog != null) {
            System.setErr(new PrintStream(new TeeOutputStream(System.err, new FileOutputStream(this.slaveLog))));
        }
        if (this.auth != null) {
            final int idx = this.auth.indexOf(58);
            if (idx < 0) {
                throw new CmdLineException(null, "No ':' in the -auth option");
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Launcher.this.auth.substring(0, idx), Launcher.this.auth.substring(idx + 1).toCharArray());
                }
            });
        }
        if (this.connectionTarget != null) {
            this.runAsTcpClient();
        } else if (this.slaveJnlpURL != null) {
            List<String> jnlpArgs = this.parseJnlpArguments();
            if (this.jarCache != null) {
                jnlpArgs.add("-jar-cache");
                jnlpArgs.add(this.jarCache.getPath());
            }
            if (this.noReconnect) {
                jnlpArgs.add("-noreconnect");
            }
            if (this.noKeepAlive) {
                jnlpArgs.add("-noKeepAlive");
            }
            try {
                Main._main(jnlpArgs.toArray(new String[jnlpArgs.size()]));
            }
            catch (CmdLineException e) {
                System.err.println("JNLP file " + this.slaveJnlpURL + " has invalid arguments: " + jnlpArgs);
                System.err.println("Most likely a configuration error in the master");
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else if (this.tcpPortFile != null) {
            this.runAsTcpServer();
        } else {
            this.runWithStdinStdout();
        }
        System.exit(0);
    }

    public List<String> parseJnlpArguments() throws ParserConfigurationException, SAXException, IOException, InterruptedException {
        if (this.secret != null) {
            this.slaveJnlpURL = new URL(this.slaveJnlpURL + "?encrypt=true");
            if (this.slaveJnlpCredentials != null) {
                throw new IOException("-jnlpCredentials and -secret are mutually exclusive");
            }
        }
        while (true) {
            try {
                Document dom;
                HttpURLConnection http;
                URLConnection con = Util.openURLConnection(this.slaveJnlpURL);
                if (con instanceof HttpURLConnection) {
                    http = (HttpURLConnection)con;
                    if (this.slaveJnlpCredentials != null) {
                        String userPassword = this.slaveJnlpCredentials;
                        String encoding = Base64.encode(userPassword.getBytes("UTF-8"));
                        http.setRequestProperty("Authorization", "Basic " + encoding);
                    }
                    if (System.getProperty("proxyCredentials", this.proxyCredentials) != null) {
                        String encoding = Base64.encode(System.getProperty("proxyCredentials", this.proxyCredentials).getBytes("UTF-8"));
                        http.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
                    }
                }
                con.connect();
                if (con instanceof HttpURLConnection && (http = (HttpURLConnection)con).getResponseCode() >= 400) {
                    throw new IOException("Failed to load " + this.slaveJnlpURL + ": " + http.getResponseCode() + " " + http.getResponseMessage());
                }
                String contentType = con.getHeaderField("Content-Type");
                String expectedContentType = this.secret == null ? "application/x-java-jnlp-file" : "application/octet-stream";
                InputStream input = con.getInputStream();
                if (this.secret != null) {
                    byte[] payload = this.toByteArray(input);
                    try {
                        Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
                        cipher.init(2, (Key)new SecretKeySpec(Launcher.fromHexString(this.secret.substring(0, Math.min(this.secret.length(), 32))), "AES"), new IvParameterSpec(payload, 0, 16));
                        byte[] decrypted = cipher.doFinal(payload, 16, payload.length - 16);
                        input = new ByteArrayInputStream(decrypted);
                    }
                    catch (GeneralSecurityException x) {
                        throw (IOException)new IOException("Failed to decrypt the JNLP file. Invalid secret key?").initCause(x);
                    }
                }
                if (contentType == null || !contentType.startsWith(expectedContentType)) {
                    try {
                        dom = Launcher.loadDom(this.slaveJnlpURL, input);
                    }
                    catch (SAXException e) {
                        throw new IOException(this.slaveJnlpURL + " doesn't look like a JNLP file; content type was " + contentType);
                    }
                    catch (IOException e) {
                        throw new IOException(this.slaveJnlpURL + " doesn't look like a JNLP file; content type was " + contentType);
                    }
                } else {
                    dom = Launcher.loadDom(this.slaveJnlpURL, input);
                }
                NodeList argElements = dom.getElementsByTagName("argument");
                ArrayList<String> jnlpArgs = new ArrayList<String>();
                for (int i = 0; i < argElements.getLength(); ++i) {
                    jnlpArgs.add(argElements.item(i).getTextContent());
                }
                if (this.slaveJnlpCredentials != null) {
                    jnlpArgs.add("-credentials");
                    jnlpArgs.add(this.slaveJnlpCredentials);
                }
                jnlpArgs.add("-headless");
                return jnlpArgs;
            }
            catch (SSLHandshakeException e) {
                if (e.getMessage().contains("PKIX path building failed")) {
                    IOException x = new IOException("Failed to validate a server certificate. If you are using a self-signed certificate, you can use the -noCertificateCheck option to bypass this check.");
                    x.initCause(e);
                    throw x;
                }
                throw e;
            }
            catch (IOException e) {
                if (this.noReconnect) {
                    throw (IOException)new IOException("Failing to obtain " + this.slaveJnlpURL).initCause(e);
                }
                System.err.println("Failing to obtain " + this.slaveJnlpURL);
                e.printStackTrace(System.err);
                System.err.println("Waiting 10 seconds before retry");
                Thread.sleep(10000L);
                continue;
            }
            break;
        }
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        int c;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = input.read()) != -1) {
            baos.write(c);
        }
        return baos.toByteArray();
    }

    private static byte[] fromHexString(String data) {
        byte[] r = new byte[data.length() / 2];
        for (int i = 0; i < data.length(); i += 2) {
            r[i / 2] = (byte)Integer.parseInt(data.substring(i, i + 2), 16);
        }
        return r;
    }

    private static Document loadDom(URL slaveJnlpURL, InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.parse(is, slaveJnlpURL.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DM_DEFAULT_ENCODING"})
    private void runAsTcpServer() throws IOException, InterruptedException {
        Socket s;
        ServerSocket ss = new ServerSocket(0, 1);
        ss.setSoTimeout(30000);
        FileWriter w = new FileWriter(this.tcpPortFile);
        try {
            w.write(String.valueOf(ss.getLocalPort()));
        }
        finally {
            w.close();
        }
        try {
            s = ss.accept();
            ss.close();
        }
        finally {
            boolean deleted = this.tcpPortFile.delete();
            if (!deleted) {
                LOGGER.log(Level.WARNING, "Cannot delete the temporary TCP port file {0}", this.tcpPortFile);
            }
        }
        this.runOnSocket(s);
    }

    private void runOnSocket(Socket s) throws IOException, InterruptedException {
        s.setKeepAlive(true);
        s.setTcpNoDelay(true);
        Launcher.main(new BufferedInputStream(SocketChannelStream.in(s)), new BufferedOutputStream(SocketChannelStream.out(s)), this.mode, this.ping, new FileSystemJarCache(this.jarCache, true));
    }

    private void runAsTcpClient() throws IOException, InterruptedException {
        Socket s = new Socket(this.connectionTarget.getAddress(), this.connectionTarget.getPort());
        this.runOnSocket(s);
    }

    private void runWithStdinStdout() throws IOException, InterruptedException {
        Launcher.ttyCheck();
        if (Launcher.isWindows()) {
            new SecureRandom().nextBoolean();
        }
        StandardOutputStream os = new StandardOutputStream();
        System.setOut(System.err);
        Launcher.main(System.in, os, this.mode, this.ping, new FileSystemJarCache(this.jarCache, true));
    }

    private static void ttyCheck() {
        try {
            Method m = System.class.getMethod("console", new Class[0]);
            Object console = m.invoke(null, new Object[0]);
            if (console != null) {
                System.out.println("WARNING: Are you running slave agent from an interactive console?\nIf so, you are probably using it incorrectly.\nSee http://wiki.jenkins-ci.org/display/JENKINS/Launching+slave.jar+from+from+console");
            }
        }
        catch (LinkageError e) {
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void main(InputStream is, OutputStream os) throws IOException, InterruptedException {
        Launcher.main(is, os, Channel.Mode.BINARY);
    }

    public static void main(InputStream is, OutputStream os, Channel.Mode mode) throws IOException, InterruptedException {
        Launcher.main(is, os, mode, false);
    }

    @Deprecated
    public static void main(InputStream is, OutputStream os, Channel.Mode mode, boolean performPing) throws IOException, InterruptedException {
        Launcher.main(is, os, mode, performPing, new FileSystemJarCache(new File(System.getProperty("user.home"), ".jenkins/cache/jars"), true));
    }

    public static void main(InputStream is, OutputStream os, Channel.Mode mode, boolean performPing, JarCache cache) throws IOException, InterruptedException {
        ExecutorService executor = Executors.newCachedThreadPool();
        ChannelBuilder cb = new ChannelBuilder("channel", executor).withMode(mode).withJarCache(cache);
        if (os instanceof StandardOutputStream) {
            cb.withProperty(StandardOutputStream.class, os);
        }
        Channel channel = cb.build(is, os);
        System.err.println("channel started");
        long timeout = 1000L * Long.parseLong(System.getProperty("hudson.remoting.Launcher.pingTimeoutSec", "240"));
        long interval = 1000L * Long.parseLong(System.getProperty("hudson.remoting.Launcher.pingIntervalSec", "0"));
        Logger.getLogger(PingThread.class.getName()).log(Level.FINE, "performPing={0} timeout={1} interval={2}", new Object[]{performPing, timeout, interval});
        if (performPing && timeout > 0L && interval > 0L) {
            new PingThread(channel, timeout, interval){

                @Override
                @Deprecated
                protected void onDead() {
                    System.err.println("Ping failed. Terminating");
                    System.exit(-1);
                }

                @Override
                protected void onDead(Throwable cause) {
                    System.err.println("Ping failed. Terminating");
                    cause.printStackTrace();
                    System.exit(-1);
                }
            }.start();
        }
        channel.join();
        System.err.println("channel stopped");
    }

    public static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeVersion() {
        Properties props = new Properties();
        InputStream is = Launcher.class.getResourceAsStream(JENKINS_VERSION_PROP_FILE);
        if (is == null) {
            LOGGER.log(Level.FINE, "Cannot locate the {0} resource file. Hudson/Jenkins version is unknown", JENKINS_VERSION_PROP_FILE);
            return UNKNOWN_JENKINS_VERSION_STR;
        }
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Launcher.closeWithLogOnly(is, JENKINS_VERSION_PROP_FILE);
        }
        return props.getProperty("version", UNKNOWN_JENKINS_VERSION_STR);
    }

    private static void closeWithLogOnly(Closeable stream, String name) {
        try {
            stream.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot close the resource file " + name, ex);
        }
    }

    private static class NoCheckTrustManager
    implements X509TrustManager {
        private NoCheckTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

