/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
public class TagBalancingHtmlStreamEventReceiver
implements HtmlStreamEventReceiver {
    private final HtmlStreamEventReceiver underlying;
    private int nestingLimit = Integer.MAX_VALUE;
    private final List<ElementContainmentInfo> openElements = Lists.newArrayList();
    ImmutableMap<String, ElementContainmentInfo> ELEMENT_CONTAINMENT_RELATIONSHIPS = ElementContainmentRelationships.access$100(new ElementContainmentRelationships());

    public TagBalancingHtmlStreamEventReceiver(HtmlStreamEventReceiver underlying) {
        this.underlying = underlying;
    }

    public void setNestingLimit(int limit) {
        if (this.openElements.size() > limit) {
            throw new IllegalStateException();
        }
        this.nestingLimit = limit;
    }

    @Override
    public void openDocument() {
        this.underlying.openDocument();
    }

    @Override
    public void closeDocument() {
        int i = Math.min(this.nestingLimit, this.openElements.size());
        while (--i >= 0) {
            this.underlying.closeTag(this.openElements.get((int)i).elementName);
        }
        this.openElements.clear();
        this.underlying.closeDocument();
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        String canonElementName = HtmlLexer.canonicalName(elementName);
        ElementContainmentInfo elInfo = (ElementContainmentInfo)this.ELEMENT_CONTAINMENT_RELATIONSHIPS.get((Object)canonElementName);
        if (elInfo == null) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.openTag(elementName, attrs);
            }
            return;
        }
        ArrayList toResumeInReverse = null;
        int i = this.openElements.size();
        while (--i >= 0) {
            ElementContainmentInfo top = this.openElements.get(i);
            if ((top.contents & elInfo.types) != 0) break;
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.closeTag(top.elementName);
            }
            this.openElements.remove(i);
            if (!top.resumable) continue;
            if (toResumeInReverse == null) {
                toResumeInReverse = Lists.newArrayList();
            }
            toResumeInReverse.add(top);
        }
        if (toResumeInReverse != null) {
            this.resume(toResumeInReverse);
        }
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.openTag(elementName, attrs);
        }
        if (!elInfo.isVoid) {
            this.openElements.add(elInfo);
        }
    }

    @Override
    public void closeTag(String elementName) {
        String canonElementName = HtmlLexer.canonicalName(elementName);
        ElementContainmentInfo elInfo = (ElementContainmentInfo)this.ELEMENT_CONTAINMENT_RELATIONSHIPS.get((Object)canonElementName);
        if (elInfo == null) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.closeTag(elementName);
            }
            return;
        }
        int index = this.openElements.lastIndexOf(elInfo);
        if (index < 0) {
            return;
        }
        int last = this.openElements.size();
        ArrayList toResumeInReverse = null;
        while (--last > index) {
            ElementContainmentInfo unclosed = this.openElements.remove(last);
            if (last + 1 < this.nestingLimit) {
                this.underlying.closeTag(unclosed.elementName);
            }
            if (!unclosed.resumable) continue;
            if (toResumeInReverse == null) {
                toResumeInReverse = Lists.newArrayList();
            }
            toResumeInReverse.add(unclosed);
        }
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.closeTag(elementName);
        }
        this.openElements.remove(index);
        if (toResumeInReverse != null) {
            this.resume(toResumeInReverse);
        }
    }

    private void resume(List<ElementContainmentInfo> toResumeInReverse) {
        for (ElementContainmentInfo toResume : toResumeInReverse) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.openTag(toResume.elementName, Lists.newArrayList());
            }
            this.openElements.add(toResume);
        }
    }

    @Override
    public void text(String text) {
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.text(text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementContainmentRelationships {
        private ImmutableMap.Builder<String, ElementContainmentInfo> definitions = ImmutableMap.builder();

        private ElementContainmentRelationships() {
            this.defineElement("a", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE_MINUS_A));
            this.defineElement("abbr", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("acronym", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("address", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.P_ELEMENT));
            this.defineElement("applet", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.PARAM_ELEMENT));
            this.defineElement("area", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.AREA_ELEMENT), 0);
            this.defineElement("audio", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("b", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("base", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.HEAD_CONTENT), 0);
            this.defineElement("basefont", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("bdi", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("bdo", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("big", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("blink", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("blockquote", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("body", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TOP_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("br", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("button", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("canvas", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("caption", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("center", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("cite", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("code", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("col", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT, ElementGroup.COL_ELEMENT), 0);
            this.defineElement("colgroup", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.COL_ELEMENT));
            this.defineElement("dd", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.DL_PART), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("del", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.MIXED), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("dfn", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("dir", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.LI_ELEMENT));
            this.defineElement("div", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("dl", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.DL_PART));
            this.defineElement("dt", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.DL_PART), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("em", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("fieldset", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.LEGEND_ELEMENT));
            this.defineElement("font", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("form", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.FORM_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT));
            this.defineElement("h1", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("h2", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("h3", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("h4", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("h5", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("h6", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("head", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TOP_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.HEAD_CONTENT));
            this.defineElement("hr", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), 0);
            this.defineElement("html", false, 0, ElementContainmentRelationships.elementGroupBits(ElementGroup.TOP_CONTENT));
            this.defineElement("i", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("iframe", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("img", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("input", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("ins", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("isindex", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE), 0);
            this.defineElement("kbd", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("label", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("legend", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.LEGEND_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("li", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.LI_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("link", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.HEAD_CONTENT), 0);
            this.defineElement("listing", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("map", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.AREA_ELEMENT));
            this.defineElement("meta", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.HEAD_CONTENT), 0);
            this.defineElement("nobr", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("noframes", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.TOP_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.TOP_CONTENT));
            this.defineElement("noscript", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("object", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.HEAD_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.PARAM_ELEMENT));
            this.defineElement("ol", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.LI_ELEMENT));
            this.defineElement("optgroup", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.OPTIONS_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.OPTIONS_ELEMENT));
            this.defineElement("option", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.OPTIONS_ELEMENT, ElementGroup.OPTION_ELEMENT), 0);
            this.defineElement("p", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.P_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.TABLE_ELEMENT));
            this.defineElement("param", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.PARAM_ELEMENT), 0);
            this.defineElement("pre", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("q", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("s", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("samp", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("script", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.MIXED, ElementGroup.TABLE_CONTENT, ElementGroup.HEAD_CONTENT, ElementGroup.TOP_CONTENT, ElementGroup.AREA_ELEMENT, ElementGroup.FORM_ELEMENT, ElementGroup.LEGEND_ELEMENT, ElementGroup.LI_ELEMENT, ElementGroup.DL_PART, ElementGroup.P_ELEMENT, ElementGroup.OPTIONS_ELEMENT, ElementGroup.OPTION_ELEMENT, ElementGroup.PARAM_ELEMENT, ElementGroup.TABLE_ELEMENT, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT, ElementGroup.COL_ELEMENT), 0);
            this.defineElement("select", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE), ElementContainmentRelationships.elementGroupBits(ElementGroup.OPTIONS_ELEMENT));
            this.defineElement("small", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("span", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("strike", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("strong", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("style", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.HEAD_CONTENT), 0);
            this.defineElement("sub", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("sup", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("table", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.TABLE_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT, ElementGroup.FORM_ELEMENT));
            this.defineElement("tbody", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.TR_ELEMENT));
            this.defineElement("td", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TD_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("textarea", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE), 0);
            this.defineElement("tfoot", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.FORM_ELEMENT, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT));
            this.defineElement("th", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TD_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK, ElementGroup.INLINE));
            this.defineElement("thead", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.FORM_ELEMENT, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT));
            this.defineElement("title", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.HEAD_CONTENT), 0);
            this.defineElement("tr", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.TABLE_CONTENT, ElementGroup.TR_ELEMENT), ElementContainmentRelationships.elementGroupBits(ElementGroup.FORM_ELEMENT, ElementGroup.TD_ELEMENT));
            this.defineElement("tt", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("u", true, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("ul", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.LI_ELEMENT));
            this.defineElement("var", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
            this.defineElement("video", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("wbr", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A), 0);
            this.defineElement("xmp", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.BLOCK), ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE));
        }

        private static int elementGroupBits(ElementGroup a) {
            return 1 << a.ordinal();
        }

        private static int elementGroupBits(ElementGroup a, ElementGroup b) {
            return 1 << a.ordinal() | 1 << b.ordinal();
        }

        private static int elementGroupBits(ElementGroup a, ElementGroup b, ElementGroup c) {
            return 1 << a.ordinal() | 1 << b.ordinal() | 1 << c.ordinal();
        }

        private static int elementGroupBits(ElementGroup ... bits) {
            int bitField = 0;
            for (ElementGroup bit : bits) {
                bitField |= 1 << bit.ordinal();
            }
            return bitField;
        }

        private void defineElement(String elementName, boolean resumable, int types, int contentTypes) {
            this.definitions.put((Object)elementName, (Object)new ElementContainmentInfo(elementName, resumable, types, contentTypes));
        }

        private ImmutableMap<String, ElementContainmentInfo> toMap() {
            return this.definitions.build();
        }

        static /* synthetic */ ImmutableMap access$100(ElementContainmentRelationships x0) {
            return x0.toMap();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ElementGroup {
            BLOCK,
            INLINE,
            INLINE_MINUS_A,
            MIXED,
            TABLE_CONTENT,
            HEAD_CONTENT,
            TOP_CONTENT,
            AREA_ELEMENT,
            FORM_ELEMENT,
            LEGEND_ELEMENT,
            LI_ELEMENT,
            DL_PART,
            P_ELEMENT,
            OPTIONS_ELEMENT,
            OPTION_ELEMENT,
            PARAM_ELEMENT,
            TABLE_ELEMENT,
            TR_ELEMENT,
            TD_ELEMENT,
            COL_ELEMENT;

        }
    }

    @Immutable
    static final class ElementContainmentInfo {
        final String elementName;
        final boolean resumable;
        final int types;
        final int contents;
        final boolean isVoid;

        ElementContainmentInfo(String elementName, boolean resumable, int types, int contents) {
            this.elementName = elementName;
            this.resumable = resumable;
            this.types = types;
            this.contents = contents;
            this.isVoid = contents == 0 && HtmlTextEscapingMode.isVoidElement(elementName);
        }

        public String toString() {
            return "<" + this.elementName + ">";
        }
    }
}

