/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.owasp.html.CssGrammar;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementAndAttributePolicyBasedSanitizerPolicy;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
class StylingPolicy
extends ElementAndAttributePolicyBasedSanitizerPolicy {
    private static final Pattern ALLOWED_CSS_SIZE = Pattern.compile("medium|(?:small|large)r|(?:xx?-)(?:small|large)|[0-9]+(p[tx]|%)");
    private static final Pattern ALLOWED_CSS_WEIGHT = Pattern.compile("normal|bold(?:er)?|lighter|[1-9]00");
    private static final Set<String> ALLOWED_CSS_STYLE = ImmutableSet.of((Object)"italic", (Object)"oblique", (Object)"normal");
    private static final Set<String> ALLOWED_TEXT_DECORATION = ImmutableSet.of((Object)"underline", (Object)"overline", (Object)"line-through");
    private static final Set<String> ALLOWED_UNICODE_BIDI = ImmutableSet.of((Object)"inherit", (Object)"normal", (Object)"embed", (Object)"bidi-override");
    private static final Set<String> ALLOWED_DIRECTION = ImmutableSet.of((Object)"inherit", (Object)"ltr", (Object)"rtl");
    private static final ImmutableMap<String, CssPropertyType> BY_CSS_PROPERTY_NAME = ImmutableMap.builder().put((Object)"font", (Object)CssPropertyType.FONT).put((Object)"font-family", (Object)CssPropertyType.FACE).put((Object)"font-size", (Object)CssPropertyType.SIZE).put((Object)"color", (Object)CssPropertyType.COLOR).put((Object)"text-align", (Object)CssPropertyType.ALIGN).put((Object)"direction", (Object)CssPropertyType.DIRECTION).put((Object)"font-weight", (Object)CssPropertyType.WEIGHT).put((Object)"font-style", (Object)CssPropertyType.STYLE).put((Object)"text-decoration", (Object)CssPropertyType.TEXT_DECORATION).put((Object)"unicode-bidi", (Object)CssPropertyType.UNICODE_BIDI).put((Object)"background", (Object)CssPropertyType.BACKGROUND_COLOR).put((Object)"background-color", (Object)CssPropertyType.BACKGROUND_COLOR).build();
    private static final ImmutableMap<String, String> COLOR_TABLE = ImmutableMap.builder().put((Object)"aliceblue", (Object)"#f0f8ff").put((Object)"antiquewhite", (Object)"#faebd7").put((Object)"aqua", (Object)"#0ff").put((Object)"aquamarine", (Object)"#7fffd4").put((Object)"azure", (Object)"#f0ffff").put((Object)"beige", (Object)"#f5f5dc").put((Object)"bisque", (Object)"#ffe4c4").put((Object)"black", (Object)"#000").put((Object)"blanchedalmond", (Object)"#ffebcd").put((Object)"blue", (Object)"#00f").put((Object)"blueviolet", (Object)"#8a2be2").put((Object)"brown", (Object)"#a52a2a").put((Object)"burlywood", (Object)"#deb887").put((Object)"cadetblue", (Object)"#5f9ea0").put((Object)"chartreuse", (Object)"#7fff00").put((Object)"chocolate", (Object)"#d2691e").put((Object)"coral", (Object)"#ff7f50").put((Object)"cornflowerblue", (Object)"#6495ed").put((Object)"cornsilk", (Object)"#fff8dc").put((Object)"crimson", (Object)"#dc143c").put((Object)"cyan", (Object)"#0ff").put((Object)"darkblue", (Object)"#00008b").put((Object)"darkcyan", (Object)"#008b8b").put((Object)"darkgoldenrod", (Object)"#b8860b").put((Object)"darkgray", (Object)"#a9a9a9").put((Object)"darkgreen", (Object)"#006400").put((Object)"darkgrey", (Object)"#a9a9a9").put((Object)"darkkhaki", (Object)"#bdb76b").put((Object)"darkmagenta", (Object)"#8b008b").put((Object)"darkolivegreen", (Object)"#556b2f").put((Object)"darkorange", (Object)"#ff8c00").put((Object)"darkorchid", (Object)"#9932cc").put((Object)"darkred", (Object)"#8b0000").put((Object)"darksalmon", (Object)"#e9967a").put((Object)"darkseagreen", (Object)"#8fbc8f").put((Object)"darkslateblue", (Object)"#483d8b").put((Object)"darkslategray", (Object)"#2f4f4f").put((Object)"darkslategrey", (Object)"#2f4f4f").put((Object)"darkturquoise", (Object)"#00ced1").put((Object)"darkviolet", (Object)"#9400d3").put((Object)"deeppink", (Object)"#ff1493").put((Object)"deepskyblue", (Object)"#00bfff").put((Object)"dimgray", (Object)"#696969").put((Object)"dimgrey", (Object)"#696969").put((Object)"dodgerblue", (Object)"#1e90ff").put((Object)"firebrick", (Object)"#b22222").put((Object)"floralwhite", (Object)"#fffaf0").put((Object)"forestgreen", (Object)"#228b22").put((Object)"fuchsia", (Object)"#f0f").put((Object)"gainsboro", (Object)"#dcdcdc").put((Object)"ghostwhite", (Object)"#f8f8ff").put((Object)"gold", (Object)"#ffd700").put((Object)"goldenrod", (Object)"#daa520").put((Object)"gray", (Object)"#808080").put((Object)"green", (Object)"#008000").put((Object)"greenyellow", (Object)"#adff2f").put((Object)"grey", (Object)"#808080").put((Object)"honeydew", (Object)"#f0fff0").put((Object)"hotpink", (Object)"#ff69b4").put((Object)"indianred", (Object)"#cd5c5c").put((Object)"indigo", (Object)"#4b0082").put((Object)"ivory", (Object)"#fffff0").put((Object)"khaki", (Object)"#f0e68c").put((Object)"lavender", (Object)"#e6e6fa").put((Object)"lavenderblush", (Object)"#fff0f5").put((Object)"lawngreen", (Object)"#7cfc00").put((Object)"lemonchiffon", (Object)"#fffacd").put((Object)"lightblue", (Object)"#add8e6").put((Object)"lightcoral", (Object)"#f08080").put((Object)"lightcyan", (Object)"#e0ffff").put((Object)"lightgoldenrodyellow", (Object)"#fafad2").put((Object)"lightgray", (Object)"#d3d3d3").put((Object)"lightgreen", (Object)"#90ee90").put((Object)"lightgrey", (Object)"#d3d3d3").put((Object)"lightpink", (Object)"#ffb6c1").put((Object)"lightsalmon", (Object)"#ffa07a").put((Object)"lightseagreen", (Object)"#20b2aa").put((Object)"lightskyblue", (Object)"#87cefa").put((Object)"lightslategray", (Object)"#789").put((Object)"lightslategrey", (Object)"#789").put((Object)"lightsteelblue", (Object)"#b0c4de").put((Object)"lightyellow", (Object)"#ffffe0").put((Object)"lime", (Object)"#0f0").put((Object)"limegreen", (Object)"#32cd32").put((Object)"linen", (Object)"#faf0e6").put((Object)"magenta", (Object)"#f0f").put((Object)"maroon", (Object)"#800000").put((Object)"mediumaquamarine", (Object)"#66cdaa").put((Object)"mediumblue", (Object)"#0000cd").put((Object)"mediumorchid", (Object)"#ba55d3").put((Object)"mediumpurple", (Object)"#9370db").put((Object)"mediumseagreen", (Object)"#3cb371").put((Object)"mediumslateblue", (Object)"#7b68ee").put((Object)"mediumspringgreen", (Object)"#00fa9a").put((Object)"mediumturquoise", (Object)"#48d1cc").put((Object)"mediumvioletred", (Object)"#c71585").put((Object)"midnightblue", (Object)"#191970").put((Object)"mintcream", (Object)"#f5fffa").put((Object)"mistyrose", (Object)"#ffe4e1").put((Object)"moccasin", (Object)"#ffe4b5").put((Object)"navajowhite", (Object)"#ffdead").put((Object)"navy", (Object)"#000080").put((Object)"oldlace", (Object)"#fdf5e6").put((Object)"olive", (Object)"#808000").put((Object)"olivedrab", (Object)"#6b8e23").put((Object)"orange", (Object)"#ffa500").put((Object)"orangered", (Object)"#ff4500").put((Object)"orchid", (Object)"#da70d6").put((Object)"palegoldenrod", (Object)"#eee8aa").put((Object)"palegreen", (Object)"#98fb98").put((Object)"paleturquoise", (Object)"#afeeee").put((Object)"palevioletred", (Object)"#db7093").put((Object)"papayawhip", (Object)"#ffefd5").put((Object)"peachpuff", (Object)"#ffdab9").put((Object)"peru", (Object)"#cd853f").put((Object)"pink", (Object)"#ffc0cb").put((Object)"plum", (Object)"#dda0dd").put((Object)"powderblue", (Object)"#b0e0e6").put((Object)"purple", (Object)"#800080").put((Object)"red", (Object)"#f00").put((Object)"rosybrown", (Object)"#bc8f8f").put((Object)"royalblue", (Object)"#4169e1").put((Object)"saddlebrown", (Object)"#8b4513").put((Object)"salmon", (Object)"#fa8072").put((Object)"sandybrown", (Object)"#f4a460").put((Object)"seagreen", (Object)"#2e8b57").put((Object)"seashell", (Object)"#fff5ee").put((Object)"sienna", (Object)"#a0522d").put((Object)"silver", (Object)"#c0c0c0").put((Object)"skyblue", (Object)"#87ceeb").put((Object)"slateblue", (Object)"#6a5acd").put((Object)"slategray", (Object)"#708090").put((Object)"slategrey", (Object)"#708090").put((Object)"snow", (Object)"#fffafa").put((Object)"springgreen", (Object)"#00ff7f").put((Object)"steelblue", (Object)"#4682b4").put((Object)"tan", (Object)"#d2b48c").put((Object)"teal", (Object)"#008080").put((Object)"thistle", (Object)"#d8bfd8").put((Object)"tomato", (Object)"#ff6347").put((Object)"turquoise", (Object)"#40e0d0").put((Object)"violet", (Object)"#ee82ee").put((Object)"wheat", (Object)"#f5deb3").put((Object)"white", (Object)"#fff").put((Object)"whitesmoke", (Object)"#f5f5f5").put((Object)"yellow", (Object)"#ff0").put((Object)"yellowgreen", (Object)"#9acd32").build();

    StylingPolicy(HtmlStreamEventReceiver out, ImmutableMap<String, ElementAndAttributePolicies> elAndAttrPolicies) {
        super(out, elAndAttrPolicies);
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        ElementAndAttributePolicies policies;
        String adjustedElementName;
        String style = null;
        Iterator<String> it = attrs.iterator();
        while (it.hasNext()) {
            String name = it.next();
            if ("style".equals(name)) {
                style = it.next();
                break;
            }
            it.next();
        }
        if ((adjustedElementName = this.applyPolicies(elementName, attrs, policies = (ElementAndAttributePolicies)this.elAndAttrPolicies.get((Object)elementName))) != null) {
            List<String> fontAttributes = null;
            if (style != null && (fontAttributes = StylingPolicy.cssPropertiesToFontAttributes(style)).isEmpty()) {
                fontAttributes = null;
            }
            if (!attrs.isEmpty() || !policies.skipIfEmpty || fontAttributes != null) {
                this.skipText = false;
                this.writeOpenTag(policies, adjustedElementName, attrs);
                if (fontAttributes != null) {
                    this.synthesizeOpenTag("font", fontAttributes);
                }
                return;
            }
        }
        this.deferOpenTag(elementName);
    }

    @VisibleForTesting
    static List<String> cssPropertiesToFontAttributes(String style) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StyleExtractor
        implements CssGrammar.PropertyHandler {
            CssPropertyType type = CssPropertyType.NONE;
            StringBuilder face;
            StringBuilder color;
            StringBuilder backgroundColor;
            String align;
            String cssSize;
            String cssWeight;
            String cssFontStyle;
            String cssTextDecoration;
            String cssDir;
            String cssUnicodeBidi;

            StyleExtractor() {
            }

            @Override
            public void url(String token) {
            }

            @Override
            public void startProperty(String propertyName) {
                CssPropertyType type = (CssPropertyType)((Object)BY_CSS_PROPERTY_NAME.get((Object)propertyName));
                this.type = type != null ? type : CssPropertyType.NONE;
            }

            @Override
            public void quotedString(String token) {
                switch (this.type) {
                    case FONT: 
                    case FACE: {
                        if (this.face == null) {
                            this.face = new StringBuilder();
                        }
                        this.face.append(' ').append(CssGrammar.cssContent(token));
                        break;
                    }
                }
            }

            @Override
            public void quantity(String token) {
                switch (this.type) {
                    case FONT: 
                    case SIZE: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_CSS_SIZE.matcher(token).matches()) break;
                        this.cssSize = token;
                        break;
                    }
                    case FACE: {
                        if (this.face == null) {
                            this.face = new StringBuilder();
                        }
                        this.face.append(' ').append(token);
                        break;
                    }
                    case BACKGROUND_COLOR: {
                        if (this.backgroundColor == null) {
                            this.backgroundColor = new StringBuilder();
                        } else {
                            this.backgroundColor.append(' ');
                        }
                        this.backgroundColor.append(token);
                        break;
                    }
                    case COLOR: {
                        if (this.color == null) {
                            this.color = new StringBuilder();
                        } else {
                            this.color.append(' ');
                        }
                        this.color.append(token);
                        break;
                    }
                    case WEIGHT: {
                        if (!ALLOWED_CSS_WEIGHT.matcher(token).matches()) break;
                        this.cssWeight = token;
                        break;
                    }
                }
            }

            @Override
            public void identifierOrHash(String token) {
                switch (this.type) {
                    case SIZE: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_CSS_SIZE.matcher(token).matches()) break;
                        this.cssSize = token;
                        break;
                    }
                    case WEIGHT: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_CSS_WEIGHT.matcher(token).matches()) break;
                        this.cssWeight = token;
                        break;
                    }
                    case FACE: {
                        if (this.face == null) {
                            this.face = new StringBuilder();
                        }
                        this.face.append(' ').append(token);
                        break;
                    }
                    case FONT: {
                        token = Strings.toLowerCase(token);
                        if (ALLOWED_CSS_WEIGHT.matcher(token).matches()) {
                            this.cssWeight = token;
                            break;
                        }
                        if (ALLOWED_CSS_SIZE.matcher(token).matches()) {
                            this.cssSize = token;
                            break;
                        }
                        if (ALLOWED_CSS_STYLE.contains(token)) {
                            this.cssFontStyle = token;
                            break;
                        }
                        if (this.face == null) {
                            this.face = new StringBuilder();
                        }
                        this.face.append(' ').append(token);
                        break;
                    }
                    case BACKGROUND_COLOR: {
                        if (this.backgroundColor != null) break;
                        this.backgroundColor = new StringBuilder();
                        this.backgroundColor.append(token);
                        break;
                    }
                    case COLOR: {
                        if (this.color != null) break;
                        this.color = new StringBuilder();
                        this.color.append(token);
                        break;
                    }
                    case STYLE: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_CSS_STYLE.contains(token)) break;
                        this.cssFontStyle = token;
                        break;
                    }
                    case ALIGN: {
                        this.align = token;
                        break;
                    }
                    case DIRECTION: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_DIRECTION.contains(token)) break;
                        this.cssDir = token;
                        break;
                    }
                    case UNICODE_BIDI: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_UNICODE_BIDI.contains(token)) break;
                        this.cssUnicodeBidi = token;
                        break;
                    }
                    case TEXT_DECORATION: {
                        token = Strings.toLowerCase(token);
                        if (!ALLOWED_TEXT_DECORATION.contains(token)) break;
                        this.cssTextDecoration = token;
                        break;
                    }
                }
            }

            @Override
            public void punctuation(String token) {
                switch (this.type) {
                    case FONT: 
                    case FACE: {
                        if (!",".equals(token) || this.face == null) break;
                        this.face.append(',');
                        break;
                    }
                    case BACKGROUND_COLOR: {
                        if (this.backgroundColor == null) break;
                        this.backgroundColor.append(token);
                        break;
                    }
                    case COLOR: {
                        if (this.color == null) break;
                        this.color.append(token);
                        break;
                    }
                }
            }

            @Override
            public void endProperty() {
                this.type = CssPropertyType.NONE;
            }

            @TCB
            List<String> toFontAttributes() {
                ImmutableList styleParts;
                String safeColor;
                ArrayList fontAttributes = Lists.newArrayList();
                if (this.face != null) {
                    fontAttributes.add("face");
                    fontAttributes.add(this.face.toString().trim());
                }
                if (this.align != null) {
                    fontAttributes.add("align");
                    fontAttributes.add(this.align);
                }
                ImmutableList.Builder b = ImmutableList.builder();
                if (this.cssWeight != null) {
                    b.add((Object)"font-weight").add((Object)this.cssWeight);
                }
                if (this.cssSize != null) {
                    b.add((Object)"font-size").add((Object)this.cssSize);
                }
                if (this.cssFontStyle != null) {
                    b.add((Object)"font-style").add((Object)this.cssFontStyle);
                }
                if (this.cssTextDecoration != null) {
                    b.add((Object)"text-decoration").add((Object)this.cssTextDecoration);
                }
                if (this.cssDir != null) {
                    b.add((Object)"direction").add((Object)this.cssDir);
                }
                if (this.cssUnicodeBidi != null) {
                    b.add((Object)"unicode-bidi").add((Object)this.cssUnicodeBidi);
                }
                if (this.backgroundColor != null && (safeColor = StylingPolicy.sanitizeColor(this.backgroundColor.toString())) != null) {
                    b.add((Object)"background-color").add((Object)safeColor);
                }
                if (this.color != null && (safeColor = StylingPolicy.sanitizeColor(this.color.toString())) != null) {
                    b.add((Object)"color").add((Object)safeColor);
                }
                if (!(styleParts = b.build()).isEmpty()) {
                    StringBuilder cssProperties = new StringBuilder();
                    boolean isPropertyName = true;
                    for (String stylePart : styleParts) {
                        cssProperties.append(stylePart).append(isPropertyName ? (char)':' : ';');
                        isPropertyName = !isPropertyName;
                    }
                    int len = cssProperties.length();
                    if (len != 0 && cssProperties.charAt(len - 1) == ';') {
                        cssProperties.setLength(len - 1);
                    }
                    fontAttributes.add("style");
                    fontAttributes.add(cssProperties.toString());
                }
                return fontAttributes;
            }
        }
        StyleExtractor extractor = new StyleExtractor();
        CssGrammar.asPropertyGroup(style, extractor);
        return extractor.toFontAttributes();
    }

    static String sanitizeColor(String s) {
        if (s.length() == 0) {
            return null;
        }
        String hex = (String)COLOR_TABLE.get((Object)(s = Strings.toLowerCase(s)));
        if (hex != null) {
            return hex;
        }
        int n = s.length();
        if (s.charAt(0) == '#') {
            if (n != 4 && n != 7) {
                return null;
            }
            for (int i = 1; i < n; ++i) {
                char ch = s.charAt(i);
                if ('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f') continue;
                return null;
            }
            return s;
        }
        if (!s.startsWith("rgb")) {
            return null;
        }
        StringBuilder sb = new StringBuilder(7);
        sb.append('#');
        if (StylingPolicy.translateDecimalOrPctByteToHex(s, StylingPolicy.translateDecimalOrPctByteToHex(s, StylingPolicy.translateDecimalOrPctByteToHex(s, 3, sb), sb), sb) == -1) {
            return null;
        }
        if (sb.charAt(1) == sb.charAt(2) && sb.charAt(3) == sb.charAt(4) && sb.charAt(5) == sb.charAt(6)) {
            sb.setCharAt(2, sb.charAt(3));
            sb.setCharAt(3, sb.charAt(5));
            sb.setLength(4);
        }
        return sb.toString();
    }

    private static boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static int translateDecimalOrPctByteToHex(String s, int i, StringBuilder out) {
        if (i == -1) {
            return -1;
        }
        int n = s.length();
        while (i < n) {
            char ch = s.charAt(i);
            if (StylingPolicy.isDecimalDigit(ch) || ch == '.') {
                int value;
                if (ch != '.') {
                    value = ch - 48;
                    while (++i < n && StylingPolicy.isDecimalDigit(ch = s.charAt(i))) {
                        value = value * 10 + (ch - 48);
                    }
                } else {
                    value = 0;
                }
                float fraction = 0.0f;
                if (s.charAt(i) == '.') {
                    int numerator = 0;
                    int denominator = 1;
                    while (++i < n && StylingPolicy.isDecimalDigit(ch = s.charAt(i))) {
                        numerator = numerator * 10 + (ch - 48);
                        denominator *= 10;
                    }
                    fraction = (float)numerator / (float)denominator;
                }
                if (i < n && s.charAt(i) == '%') {
                    value = (int)Math.round((double)((float)value + fraction) * 2.55);
                    ++i;
                } else if (value < 255 && (double)fraction > 0.5) {
                    ++value;
                }
                if (0 <= value && value <= 255) {
                    out.append("0123456789abcdef".charAt(value >>> 4)).append("0123456789abcdef".charAt(value & 0xF));
                    return i;
                }
                return -1;
            }
            ++i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CssPropertyType {
        FONT,
        FACE,
        SIZE,
        BACKGROUND_COLOR,
        COLOR,
        DIRECTION,
        UNICODE_BIDI,
        ALIGN,
        WEIGHT,
        STYLE,
        TEXT_DECORATION,
        NONE;

    }
}

