/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import javax.annotation.Nullable;
import org.owasp.html.JoinedAttributePolicy;
import org.owasp.html.TCB;

@TCB
public interface AttributePolicy {
    public static final AttributePolicy IDENTITY_ATTRIBUTE_POLICY = new AttributePolicy(){

        public String apply(String elementName, String attributeName, String value) {
            return value;
        }
    };
    public static final AttributePolicy REJECT_ALL_ATTRIBUTE_POLICY = new AttributePolicy(){

        @Nullable
        public String apply(String elementName, String attributeName, String value) {
            return null;
        }
    };

    @Nullable
    public String apply(String var1, String var2, String var3);

    public static final class Util {
        public static final AttributePolicy join(AttributePolicy ... policies) {
            class PolicyJoiner {
                AttributePolicy last = null;
                AttributePolicy out = null;

                PolicyJoiner() {
                }

                void join(AttributePolicy p) {
                    if (REJECT_ALL_ATTRIBUTE_POLICY.equals(p)) {
                        this.out = p;
                    } else if (!REJECT_ALL_ATTRIBUTE_POLICY.equals(this.out)) {
                        if (p instanceof JoinedAttributePolicy) {
                            JoinedAttributePolicy jap = (JoinedAttributePolicy)p;
                            this.join(jap.first);
                            this.join(jap.second);
                        } else if (p != this.last) {
                            this.last = p;
                            if (this.out == null || IDENTITY_ATTRIBUTE_POLICY.equals(this.out)) {
                                this.out = p;
                            } else if (!IDENTITY_ATTRIBUTE_POLICY.equals(p)) {
                                this.out = new JoinedAttributePolicy(this.out, p);
                            }
                        }
                    }
                }
            }
            PolicyJoiner pu = new PolicyJoiner();
            for (AttributePolicy policy : policies) {
                if (policy == null) continue;
                pu.join(policy);
            }
            return pu.out != null ? pu.out : IDENTITY_ATTRIBUTE_POLICY;
        }
    }
}

