/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUser;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.transport.TransportManager;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.JavaProvider;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.PluginImpl;
import hudson.plugins.sshslaves.RemoteLauncher;
import hudson.plugins.sshslaves.SFTPClient;
import hudson.plugins.sshslaves.SFTPFileSystem;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.SlaveComputer;
import hudson.tools.JDKInstaller;
import hudson.tools.ToolLocationNodeProperty;
import hudson.util.DescribableList;
import hudson.util.IOException2;
import hudson.util.ListBoxModel;
import hudson.util.NullStream;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SSHLauncher
extends ComputerLauncher {
    public static final SchemeRequirement SSH_SCHEME = new SchemeRequirement("ssh");
    public static final String JDKVERSION = "jdk-7u80";
    public static final String DEFAULT_JDK = "jdk-7u80-oth-JPR";
    private final String host;
    private final int port;
    private String credentialsId;
    private transient StandardUsernameCredentials credentials;
    @Deprecated
    private transient String username;
    @Deprecated
    private transient Secret password;
    @Deprecated
    private transient String privatekey;
    private final String jvmOptions;
    public final String javaPath;
    private JDKInstaller jdk = null;
    private transient Connection connection;
    private transient Session session;
    public final String prefixStartSlaveCmd;
    public final String suffixStartSlaveCmd;
    public final Integer launchTimeoutSeconds;
    public final Integer maxNumRetries;
    public final Integer retryWaitTime;
    private static final Logger LOGGER = Logger.getLogger(SSHLauncher.class.getName());

    @DataBoundConstructor
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this(host, port, SSHLauncher.lookupSystemCredentials(credentialsId), jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime);
    }

    @Deprecated
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds) {
        this(host, port, SSHLauncher.lookupSystemCredentials(credentialsId), jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, null, null);
    }

    @Deprecated
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, SSHLauncher.lookupSystemCredentials(credentialsId), jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId, String host, int port) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME, new HostnamePortRequirement(host, port)}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this(host, port, credentials, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime);
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds) {
        this(host, port, credentials, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, null, null);
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, credentials, jvmOptions, javaPath, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
    }

    @Deprecated
    public SSHLauncher(String host, int port, SSHUser credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, (StandardUsernameCredentials)credentials, jvmOptions, javaPath, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
    }

    @Deprecated
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, username, password, privatekey, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd);
    }

    @Deprecated
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this.host = host;
        this.jvmOptions = Util.fixEmpty((String)jvmOptions);
        this.port = port == 0 ? 22 : port;
        this.username = Util.fixEmpty((String)username);
        this.password = Secret.fromString((String)Util.fixEmpty((String)password));
        this.privatekey = Util.fixEmpty((String)privatekey);
        this.credentials = null;
        this.credentialsId = null;
        this.javaPath = Util.fixEmpty((String)javaPath);
        if (jdkInstaller != null) {
            this.jdk = jdkInstaller;
        }
        this.prefixStartSlaveCmd = Util.fixEmpty((String)prefixStartSlaveCmd);
        this.suffixStartSlaveCmd = Util.fixEmpty((String)suffixStartSlaveCmd);
        this.launchTimeoutSeconds = null;
        this.maxNumRetries = null;
        this.retryWaitTime = null;
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, credentials, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
    }

    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this.host = host;
        this.jvmOptions = Util.fixEmpty((String)jvmOptions);
        this.port = port == 0 ? 22 : port;
        this.username = null;
        this.password = null;
        this.privatekey = null;
        this.credentials = credentials;
        this.credentialsId = credentials == null ? null : credentials.getId();
        this.javaPath = Util.fixEmpty((String)javaPath);
        if (jdkInstaller != null) {
            this.jdk = jdkInstaller;
        }
        this.prefixStartSlaveCmd = Util.fixEmpty((String)prefixStartSlaveCmd);
        this.suffixStartSlaveCmd = Util.fixEmpty((String)suffixStartSlaveCmd);
        this.launchTimeoutSeconds = launchTimeoutSeconds == null || launchTimeoutSeconds <= 0 ? null : launchTimeoutSeconds;
        this.maxNumRetries = maxNumRetries != null && maxNumRetries > 0 ? maxNumRetries : 0;
        this.retryWaitTime = retryWaitTime != null && retryWaitTime > 0 ? retryWaitTime : 0;
    }

    @Deprecated
    public SSHLauncher(String host, int port, SSHUser credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, (StandardUsernameCredentials)credentials, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd);
    }

    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions) {
        this(host, port, username, password, privatekey, jvmOptions, null, null, null);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials() {
        String credentialsId = this.credentialsId == null ? (this.credentials == null ? null : this.credentials.getId()) : this.credentialsId;
        try {
            StandardUsernameCredentials credentials;
            StandardUsernameCredentials standardUsernameCredentials = credentials = credentialsId != null ? SSHLauncher.lookupSystemCredentials(credentialsId) : null;
            if (credentials != null) {
                this.credentials = credentials;
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.credentials == null && credentialsId == null && (this.username != null || this.password != null || this.privatekey != null)) {
            this.credentials = SSHLauncher.upgrade(this.username, this.password, this.privatekey, this.host);
            this.credentialsId = this.credentials.getId();
        }
        return this.credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static synchronized StandardUsernameCredentials upgrade(String username, Secret password, String privatekey, String description) {
        Object u = SSHLauncher.retrieveExistingCredentials(username = StringUtils.isEmpty((String)username) ? System.getProperty("user.name") : username, password, privatekey);
        if (u != null) {
            return u;
        }
        u = StringUtils.isEmpty((String)privatekey) && (password == null || StringUtils.isEmpty((String)password.getPlainText())) ? new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, username, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.UsersPrivateKeySource(), null, description) : (StringUtils.isNotEmpty((String)privatekey) ? new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, username, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.FileOnMasterPrivateKeySource(privatekey), password == null ? null : password.getEncryptedValue(), MessageFormat.format("{0} - key file: {1}", description, privatekey)) : new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, description, username, password == null ? null : password.getEncryptedValue()));
        SecurityContext securityContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
            try {
                s.addCredentials(Domain.global(), (Credentials)u);
                StandardUsernameCredentials standardUsernameCredentials = u;
                return standardUsernameCredentials;
            }
            catch (IOException iOException) {
                SecurityContextHolder.setContext((SecurityContext)securityContext);
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
        }
        return u;
    }

    private static StandardUsernameCredentials retrieveExistingCredentials(String username, final Secret password, String privatekey) {
        final String privatekeyContent = SSHLauncher.getPrivateKeyContent(password, privatekey);
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Hudson.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME}), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withUsername((String)username), new CredentialsMatcher(){

            public boolean matches(@NonNull Credentials item) {
                if (item instanceof StandardUsernamePasswordCredentials && password != null && ((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(item)).getPassword().equals((Object)password)) {
                    return true;
                }
                if (privatekeyContent != null && item instanceof SSHUserPrivateKey) {
                    for (String key : ((SSHUserPrivateKey)SSHUserPrivateKey.class.cast(item)).getPrivateKeys()) {
                        if (!SSHLauncher.pemKeyEquals(key, privatekeyContent)) continue;
                        return true;
                    }
                }
                return false;
            }
        }}));
    }

    private static boolean pemKeyEquals(String key1, String key2) {
        key1 = StringUtils.trim((String)key1);
        key2 = StringUtils.trim((String)key2);
        return StringUtils.equals((String)key1.replaceAll("\\s+", ""), (String)key2.replace("\\s+", "")) || Arrays.equals(SSHLauncher.quickNDirtyExtract(key1), SSHLauncher.quickNDirtyExtract(key2));
    }

    private static byte[] quickNDirtyExtract(String key) {
        StringBuilder builder = new StringBuilder(key.length());
        boolean begin = false;
        boolean header = false;
        for (String line : StringUtils.split((String)key, (String)"\n")) {
            if ((line = line.trim()).startsWith("---") && line.endsWith("---")) {
                if (begin && line.contains("---END")) break;
                if (!begin && line.contains("---BEGIN")) {
                    header = true;
                    begin = true;
                    continue;
                }
            }
            if (StringUtils.isBlank((String)line)) {
                header = false;
                continue;
            }
            if (header) continue;
            builder.append(line);
        }
        return Base64.decodeBase64((String)builder.toString());
    }

    private static String getPrivateKeyContent(Secret password, String privatekey) {
        if ((privatekey = Util.fixEmpty((String)privatekey)) != null) {
            try {
                File key = new File(privatekey);
                if (key.exists()) {
                    if (PuTTYKey.isPuTTYKeyFile((File)key)) {
                        return Util.fixEmptyAndTrim((String)new PuTTYKey(key, password.getPlainText()).toOpenSSH());
                    }
                    return Util.fixEmptyAndTrim((String)FileUtils.readFileToString((File)key));
                }
            }
            catch (Throwable t) {
                LOGGER.warning("invalid private key file " + privatekey);
            }
        }
        return null;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public String getJvmOptions() {
        return this.jvmOptions == null ? "" : this.jvmOptions;
    }

    public String getJavaPath() {
        return this.javaPath == null ? "" : this.javaPath;
    }

    protected String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    @CheckForNull
    private static String getWorkingDirectory(SlaveComputer computer) {
        return SSHLauncher.getWorkingDirectory(computer.getNode());
    }

    @CheckForNull
    private static String getWorkingDirectory(@CheckForNull Slave slave) {
        if (slave == null) {
            return null;
        }
        String workingDirectory = slave.getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    public synchronized void launch(final SlaveComputer computer, final TaskListener listener) throws InterruptedException {
        this.connection = new Connection(this.host, this.port);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        HashSet<2> callables = new HashSet<2>();
        callables.add(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws InterruptedException {
                Boolean rval = Boolean.FALSE;
                try {
                    SSHLauncher.this.openConnection(listener);
                    SSHLauncher.this.verifyNoHeaderJunk(listener);
                    SSHLauncher.this.reportEnvironment(listener);
                    String java = SSHLauncher.this.resolveJava(computer, listener);
                    String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
                    if (workingDirectory == null) {
                        listener.error("Cannot get the working directory for " + computer);
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    SSHLauncher.this.copySlaveJar(listener, workingDirectory);
                    SSHLauncher.this.startSlave(computer, listener, java, workingDirectory);
                    PluginImpl.register(SSHLauncher.this.connection);
                    rval = Boolean.TRUE;
                    return rval;
                }
                catch (RuntimeException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
                }
                catch (Error e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
                }
                catch (IOException e) {
                    e.printStackTrace(listener.getLogger());
                }
                finally {
                    return rval;
                }
            }
        });
        Slave node = computer.getNode();
        String nodeName = node != null ? node.getNodeName() : "unknown";
        try {
            Boolean res;
            long time = System.currentTimeMillis();
            List results = this.getLaunchTimeoutMillis() > 0L ? executorService.invokeAll(callables, this.getLaunchTimeoutMillis(), TimeUnit.MILLISECONDS) : executorService.invokeAll(callables);
            long duration = System.currentTimeMillis() - time;
            try {
                res = (Boolean)results.get(0).get();
            }
            catch (ExecutionException e) {
                res = Boolean.FALSE;
            }
            if (!res.booleanValue()) {
                System.out.println(Messages.SSHLauncher_LaunchFailedDuration(this.getTimestamp(), nodeName, this.host, duration));
                listener.getLogger().println(this.getTimestamp() + " Launch failed - cleaning up connection");
                this.cleanupConnection(listener);
            } else {
                System.out.println(Messages.SSHLauncher_LaunchCompletedDuration(this.getTimestamp(), nodeName, this.host, duration));
            }
            executorService.shutdown();
        }
        catch (InterruptedException e) {
            System.out.println(Messages.SSHLauncher_LaunchFailed(this.getTimestamp(), nodeName, this.host));
        }
    }

    private void cleanupConnection(TaskListener listener) {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed(this.getTimestamp()));
        }
    }

    protected String resolveJava(SlaveComputer computer, TaskListener listener) throws InterruptedException, IOException2 {
        if (StringUtils.isNotBlank((String)this.javaPath)) {
            return this.expandExpression(computer, this.javaPath);
        }
        String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
        if (workingDirectory == null) {
            throw new IOException2("Cannot retrieve a working directory of " + computer, null);
        }
        ArrayList<String> tried = new ArrayList<String>();
        for (JavaProvider provider : JavaProvider.all()) {
            for (String javaCommand : provider.getJavas(computer, listener, this.connection)) {
                LOGGER.fine("Trying Java at " + javaCommand);
                try {
                    tried.add(javaCommand);
                    return this.checkJavaVersion(listener, javaCommand);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to check the Java version", e);
                }
            }
        }
        try {
            return this.attemptToInstallJDK(listener, workingDirectory);
        }
        catch (IOException e) {
            throw new IOException2("Could not find any known supported java version in " + tried + ", and we also failed to install JDK as a fallback", (Throwable)e);
        }
    }

    private String expandExpression(SlaveComputer computer, String expression) {
        return this.getEnvVars(computer).expand(expression);
    }

    private EnvVars getEnvVars(SlaveComputer computer) {
        EnvVars local;
        EnvVars global = this.getEnvVars(Hudson.getInstance());
        Slave node = computer.getNode();
        EnvVars envVars = local = node != null ? this.getEnvVars((Node)node) : null;
        if (global != null) {
            if (local != null) {
                EnvVars merged = new EnvVars(global);
                merged.overrideAll((Map)local);
                return merged;
            }
            return global;
        }
        if (local != null) {
            return local;
        }
        return new EnvVars();
    }

    private EnvVars getEnvVars(Hudson h) {
        return this.getEnvVars(h.getGlobalNodeProperties());
    }

    private EnvVars getEnvVars(Node n) {
        return this.getEnvVars(n.getNodeProperties());
    }

    private EnvVars getEnvVars(DescribableList<NodeProperty<?>, NodePropertyDescriptor> dl) {
        EnvironmentVariablesNodeProperty evnp = (EnvironmentVariablesNodeProperty)dl.get(EnvironmentVariablesNodeProperty.class);
        if (evnp == null) {
            return null;
        }
        return evnp.getEnvVars();
    }

    private void verifyNoHeaderJunk(TaskListener listener) throws IOException, InterruptedException {
        String s;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.connection.exec("true", (OutputStream)baos);
        try {
            s = baos.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Default encoding is unsupported", ex);
        }
        if (s.length() != 0) {
            listener.getLogger().println(Messages.SSHLauncher_SSHHeeaderJunkDetected());
            listener.getLogger().println(s);
            throw new AbortException();
        }
    }

    private JDKInstaller getJDKInstaller() {
        return this.jdk != null ? this.jdk : new JDKInstaller(DEFAULT_JDK, true);
    }

    private String attemptToInstallJDK(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        String uname;
        ByteArrayOutputStream unameOutput = new ByteArrayOutputStream();
        if (this.connection.exec("uname -a", (OutputStream)new TeeOutputStream((OutputStream)unameOutput, (OutputStream)listener.getLogger())) != 0) {
            throw new IOException("Failed to run 'uname' to obtain the environment");
        }
        try {
            uname = unameOutput.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Default encoding is unsupported", ex);
        }
        JDKInstaller.Platform p = null;
        JDKInstaller.CPU cpu = null;
        if (uname.contains("GNU/Linux")) {
            p = JDKInstaller.Platform.LINUX;
        }
        if (uname.contains("SunOS")) {
            p = JDKInstaller.Platform.SOLARIS;
        }
        if (uname.contains("CYGWIN")) {
            p = JDKInstaller.Platform.WINDOWS;
        }
        if (uname.contains("Windows_NT")) {
            p = JDKInstaller.Platform.WINDOWS;
        }
        if (uname.contains("sparc")) {
            cpu = JDKInstaller.CPU.Sparc;
        }
        if (uname.contains("x86_64")) {
            cpu = JDKInstaller.CPU.amd64;
        }
        if (Pattern.compile("\\bi?[3-6]86\\b").matcher(uname).find()) {
            cpu = JDKInstaller.CPU.i386;
        }
        if (p == null || cpu == null) {
            throw new IOException(Messages.SSHLauncher_FailedToDetectEnvironment(uname));
        }
        String javaDir = workingDirectory + "/jdk";
        String bundleFile = workingDirectory + "/" + p.bundleFileName;
        SFTPClient sftp = new SFTPClient(this.connection);
        this.connection.exec("rm -rf " + javaDir, (OutputStream)listener.getLogger());
        sftp.mkdirs(javaDir, 493);
        URL bundle = this.getJDKInstaller().locate(listener, p, cpu);
        listener.getLogger().println("Installing jdk-7u80");
        Util.copyStreamAndClose((InputStream)bundle.openStream(), (OutputStream)new BufferedOutputStream(sftp.writeToFile(bundleFile), 32768));
        sftp.chmod(bundleFile, 493);
        this.getJDKInstaller().install((Launcher)new RemoteLauncher(listener, this.connection), p, (JDKInstaller.FileSystem)new SFTPFileSystem(sftp), listener, javaDir, bundleFile);
        return javaDir + "/bin/java";
    }

    private void startSlave(SlaveComputer computer, TaskListener listener, String java, String workingDirectory) throws IOException {
        this.session = this.connection.openSession();
        this.expandChannelBufferSize(this.session, listener);
        String cmd = "cd \"" + workingDirectory + "\" && " + java + " " + this.getJvmOptions() + " -jar slave.jar";
        cmd = this.getPrefixStartSlaveCmd() + cmd + this.getSuffixStartSlaveCmd();
        listener.getLogger().println(Messages.SSHLauncher_StartingSlaveProcess(this.getTimestamp(), cmd));
        this.session.execCommand(cmd);
        this.session.pipeStderr((OutputStream)new DelegateNoCloseOutputStream(listener.getLogger()));
        try {
            computer.setChannel(this.session.getStdout(), this.session.getStdin(), (OutputStream)listener.getLogger(), null);
        }
        catch (InterruptedException e) {
            this.session.close();
            throw new IOException2(Messages.SSHLauncher_AbortedDuringConnectionOpen(), (Throwable)e);
        }
        catch (IOException e) {
            try {
                throw new IOException2(this.getSessionOutcomeMessage(this.session, false), (Throwable)e);
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    private void expandChannelBufferSize(Session session, TaskListener listener) {
        int sz = 4;
        session.setWindowSize(sz * 1024 * 1024);
        listener.getLogger().println("Expanded the channel window size to " + sz + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySlaveJar(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        block22: {
            String fileName = workingDirectory + "/slave.jar";
            listener.getLogger().println(Messages.SSHLauncher_StartingSFTPClient(this.getTimestamp()));
            SFTPClient sftpClient = null;
            try {
                sftpClient = new SFTPClient(this.connection);
                try {
                    SFTPv3FileAttributes fileAttributes = sftpClient._stat(workingDirectory);
                    if (fileAttributes == null) {
                        listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(this.getTimestamp(), workingDirectory));
                        sftpClient.mkdirs(workingDirectory, 448);
                    } else if (fileAttributes.isRegularFile()) {
                        throw new IOException(Messages.SSHLauncher_RemoteFSIsAFile(workingDirectory));
                    }
                    try {
                        sftpClient.rm(fileName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    listener.getLogger().println(Messages.SSHLauncher_CopyingSlaveJar(this.getTimestamp()));
                    try {
                        byte[] slaveJar = new Slave.JnlpJar("slave.jar").readFully();
                        OutputStream os = sftpClient.writeToFile(fileName);
                        try {
                            os.write(slaveJar);
                        }
                        finally {
                            os.close();
                        }
                        listener.getLogger().println(Messages.SSHLauncher_CopiedXXXBytes(this.getTimestamp(), slaveJar.length));
                    }
                    catch (Error error) {
                        throw error;
                    }
                    catch (Throwable e) {
                        throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJarTo(fileName), e);
                    }
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable e) {
                    throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJarInto(workingDirectory), e);
                }
            }
            catch (IOException e) {
                if (sftpClient == null) {
                    this.copySlaveJarUsingSCP(listener, workingDirectory);
                    break block22;
                }
                throw e;
            }
            finally {
                if (sftpClient != null) {
                    sftpClient.close();
                }
            }
        }
    }

    private void copySlaveJarUsingSCP(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.SSHLauncher_StartingSCPClient(this.getTimestamp()));
        SCPClient scp = new SCPClient(this.connection);
        try {
            if (this.connection.exec("test -d " + workingDirectory, (OutputStream)listener.getLogger()) != 0) {
                listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(this.getTimestamp(), workingDirectory));
                if (this.connection.exec("mkdir -p " + workingDirectory, (OutputStream)listener.getLogger()) != 0) {
                    listener.getLogger().println("Failed to create " + workingDirectory);
                }
            }
            this.connection.exec("rm " + workingDirectory + "/slave.jar", (OutputStream)new NullStream());
            InputStream is = Hudson.getInstance().servletContext.getResourceAsStream("/WEB-INF/slave.jar");
            listener.getLogger().println(Messages.SSHLauncher_CopyingSlaveJar(this.getTimestamp()));
            scp.put(IOUtils.toByteArray((InputStream)is), "slave.jar", workingDirectory, "0644");
        }
        catch (IOException e) {
            throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJarInto(workingDirectory), (Throwable)e);
        }
    }

    protected void reportEnvironment(TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages._SSHLauncher_RemoteUserEnvironment(this.getTimestamp()));
        this.connection.exec("set", (OutputStream)listener.getLogger());
    }

    @NonNull
    private String checkJavaVersion(TaskListener listener, String javaCommand) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.SSHLauncher_CheckingDefaultJava(this.getTimestamp(), javaCommand));
        StringWriter output = new StringWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.connection.exec(javaCommand + " " + this.getJvmOptions() + " -version", (OutputStream)out);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()), Charset.defaultCharset()));
        String result = this.checkJavaVersion(listener.getLogger(), javaCommand, r, output);
        if (null == result) {
            listener.getLogger().println(Messages.SSHLauncher_UknownJavaVersion(javaCommand));
            listener.getLogger().println(output);
            throw new IOException(Messages.SSHLauncher_UknownJavaVersion(javaCommand));
        }
        return result;
    }

    @CheckForNull
    protected String checkJavaVersion(PrintStream logger, String javaCommand, BufferedReader r, StringWriter output) throws IOException {
        String line;
        while (null != (line = r.readLine())) {
            output.write(line);
            output.write("\n");
            if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("java version \"") && !line.startsWith("openjdk version \"")) continue;
            String versionStr = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            logger.println(Messages.SSHLauncher_JavaVersionResult(this.getTimestamp(), javaCommand, versionStr));
            try {
                Number version = NumberFormat.getNumberInstance(Locale.US).parse(versionStr);
                if (version.doubleValue() < 1.5) {
                    throw new IOException(Messages.SSHLauncher_NoJavaFound(line));
                }
            }
            catch (ParseException e) {
                throw new IOException(Messages.SSHLauncher_NoJavaFound(line));
            }
            return javaCommand;
        }
        return null;
    }

    protected void openConnection(TaskListener listener) throws IOException, InterruptedException {
        StandardUsernameCredentials credentials;
        listener.getLogger().println(Messages.SSHLauncher_OpeningSSHConnection(this.getTimestamp(), this.host + ":" + this.port));
        this.connection.setTCPNoDelay(true);
        int maxNumRetries = this.maxNumRetries == null || this.maxNumRetries < 0 ? 0 : this.maxNumRetries;
        for (int i = 0; i <= maxNumRetries; ++i) {
            try {
                this.connection.connect();
                break;
            }
            catch (IOException ioexception) {
                listener.getLogger().println(ioexception.getCause().getMessage());
                String ioExceptionMessageCause = "";
                if (ioexception.getCause() != null) {
                    ioExceptionMessageCause = ioexception.getCause().getMessage();
                }
                if (!ioExceptionMessageCause.equals("Connection refused")) break;
                if (maxNumRetries - i <= 0) {
                    listener.getLogger().println("SSH Connection failed with IOException: \"" + ioExceptionMessageCause + "\".");
                    throw ioexception;
                }
                listener.getLogger().println("SSH Connection failed with IOException: \"" + ioExceptionMessageCause + "\", retrying in " + this.retryWaitTime + " seconds.  There are " + (maxNumRetries - i) + " more retries left.");
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.retryWaitTime.intValue()));
                continue;
            }
        }
        if ((credentials = this.getCredentials()) == null) {
            throw new AbortException("Cannot find SSH User credentials with id: " + this.credentialsId);
        }
        if (!SSHAuthenticator.newInstance((Object)this.connection, (StandardUsernameCredentials)credentials).authenticate(listener) || !this.connection.isAuthenticationComplete()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticationFailed(this.getTimestamp()));
            throw new AbortException(Messages.SSHLauncher_AuthenticationFailedException());
        }
        listener.getLogger().println(Messages.SSHLauncher_AuthenticationSuccessful(this.getTimestamp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, final TaskListener listener) {
        if (this.connection != null) {
            Slave n;
            boolean connectionLost = this.reportTransportLoss(this.connection, listener);
            if (this.session != null) {
                try {
                    listener.getLogger().println(this.getSessionOutcomeMessage(this.session, connectionLost));
                    this.session.getStdout().close();
                    this.session.close();
                }
                catch (Throwable t) {
                    t.printStackTrace(listener.error(Messages.SSHLauncher_ErrorWhileClosingConnection()));
                }
                this.session = null;
            }
            if ((n = slaveComputer.getNode()) != null && !connectionLost) {
                String workingDirectory = SSHLauncher.getWorkingDirectory(n);
                final String fileName = workingDirectory + "/slave.jar";
                Future<?> tidyUp = Computer.threadPoolForRemoting.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block10: {
                            SFTPv3Client sftpClient = null;
                            try {
                                sftpClient = new SFTPv3Client(SSHLauncher.this.connection);
                                sftpClient.rm(fileName);
                            }
                            catch (Exception e) {
                                if (sftpClient == null) {
                                    try {
                                        SSHLauncher.this.connection.exec("rm " + fileName, (OutputStream)listener.getLogger());
                                        break block10;
                                    }
                                    catch (Error error) {
                                        throw error;
                                    }
                                    catch (Throwable x) {
                                        x.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(SSHLauncher.this.getTimestamp())));
                                        break block10;
                                    }
                                }
                                e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(SSHLauncher.this.getTimestamp())));
                            }
                            finally {
                                if (sftpClient != null) {
                                    sftpClient.close();
                                }
                            }
                        }
                    }
                });
                try {
                    tidyUp.get(this.launchTimeoutSeconds == null ? 60L : (long)this.launchTimeoutSeconds.intValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(this.getTimestamp())));
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(this.getTimestamp())));
                }
                catch (TimeoutException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(this.getTimestamp())));
                }
                finally {
                    if (!tidyUp.isDone()) {
                        tidyUp.cancel(true);
                    }
                }
            }
            PluginImpl.unregister(this.connection);
            this.cleanupConnection(listener);
        }
    }

    private boolean reportTransportLoss(Connection c, TaskListener listener) {
        TransportManager tm = null;
        try {
            Field f = Connection.class.getDeclaredField("tm");
            f.setAccessible(true);
            tm = (TransportManager)f.get(c);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace(listener.error("Failed to get to TransportManager"));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(listener.error("Failed to get to TransportManager"));
        }
        if (tm == null) {
            listener.error("Couldn't get to TransportManager.");
            return false;
        }
        Throwable cause = tm.getReasonClosedCause();
        if (cause != null) {
            cause.printStackTrace(listener.error("Socket connection to SSH server was lost"));
        }
        return cause != null;
    }

    private String getSessionOutcomeMessage(Session session, boolean isConnectionLost) throws InterruptedException {
        session.waitForCondition(96, 3000L);
        Integer exitCode = session.getExitStatus();
        if (exitCode != null) {
            return "Slave JVM has terminated. Exit code=" + exitCode;
        }
        String sig = session.getExitSignal();
        if (sig != null) {
            return "Slave JVM has terminated. Exit signal=" + sig;
        }
        if (isConnectionLost) {
            return "Slave JVM has not reported exit code before the socket was lost";
        }
        return "Slave JVM has not reported exit code. Is it still running?";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password != null ? Secret.toString((Secret)this.password) : null;
    }

    @Deprecated
    public String getPrivatekey() {
        return this.privatekey;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getPrefixStartSlaveCmd() {
        return this.prefixStartSlaveCmd == null ? "" : this.prefixStartSlaveCmd;
    }

    public String getSuffixStartSlaveCmd() {
        return this.suffixStartSlaveCmd == null ? "" : this.suffixStartSlaveCmd;
    }

    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    private long getLaunchTimeoutMillis() {
        return this.launchTimeoutSeconds == null ? 0L : TimeUnit.SECONDS.toMillis(this.launchTimeoutSeconds.intValue());
    }

    public Integer getMaxNumRetries() {
        return this.maxNumRetries == null || this.maxNumRetries < 0 ? Integer.valueOf(0) : this.maxNumRetries;
    }

    public Integer getRetryWaitTime() {
        return this.retryWaitTime;
    }

    private static class DelegateNoCloseOutputStream
    extends OutputStream {
        private OutputStream out;

        public DelegateNoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            this.out = null;
        }

        @Override
        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.out != null) {
                this.out.write(b, off, len);
            }
        }
    }

    @Extension
    public static class DefaultJavaProvider
    extends JavaProvider {
        @Override
        public List<String> getJavas(SlaveComputer computer, TaskListener listener, Connection connection) {
            Slave node;
            DescribableList list;
            ArrayList<String> javas = new ArrayList<String>(Arrays.asList("java", "/usr/bin/java", "/usr/java/default/bin/java", "/usr/java/latest/bin/java", "/usr/local/bin/java", "/usr/local/java/bin/java"));
            String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
            if (workingDirectory != null) {
                javas.add(workingDirectory + "/jdk/bin/java");
            }
            DescribableList describableList = list = (node = computer.getNode()) != null ? node.getNodeProperties() : null;
            if (list != null) {
                Descriptor jdk = Hudson.getInstance().getDescriptorByType(JDK.DescriptorImpl.class);
                for (NodeProperty prop : list) {
                    if (prop instanceof EnvironmentVariablesNodeProperty) {
                        EnvVars env = ((EnvironmentVariablesNodeProperty)prop).getEnvVars();
                        if (env == null || !env.containsKey((Object)"JAVA_HOME")) continue;
                        javas.add((String)env.get((Object)"JAVA_HOME") + "/bin/java");
                        continue;
                    }
                    if (!(prop instanceof ToolLocationNodeProperty)) continue;
                    for (ToolLocationNodeProperty.ToolLocation tool : ((ToolLocationNodeProperty)prop).getLocations()) {
                        if (tool.getType() != jdk) continue;
                        javas.add(tool.getHome() + "/bin/java");
                    }
                }
            }
            return javas;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }

        public Class getSshConnectorClass() {
            return SSHConnector.class;
        }

        public String getHelpFile(String fieldName) {
            String n = super.getHelpFile(fieldName);
            if (n == null) {
                n = Hudson.getInstance().getDescriptor(SSHConnector.class).getHelpFile(fieldName);
            }
            return n;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String host, @QueryParameter String port) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (_context == null || !_context.hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                int portValue = Integer.parseInt(port);
                return new StandardUsernameListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME, new HostnamePortRequirement(host, portValue)}));
            }
            catch (NumberFormatException ex) {
                return new ListBoxModel();
            }
        }
    }

    public static class DefaultJDKInstaller
    extends JDKInstaller {
        public DefaultJDKInstaller() {
            super(SSHLauncher.DEFAULT_JDK, true);
        }

        public Object readResolve() {
            return new JDKInstaller(SSHLauncher.DEFAULT_JDK, true);
        }
    }
}

