/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerConnectorDescriptor;
import hudson.tools.JDKInstaller;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class SSHConnector
extends ComputerConnector {
    public final int port;
    private String credentialsId;
    private transient StandardUsernameCredentials credentials;
    @Deprecated
    public transient String username;
    @Deprecated
    public transient Secret password;
    @Deprecated
    public transient String privatekey;
    public final String jvmOptions;
    public final String javaPath;
    public final JDKInstaller jdkInstaller;
    public final String prefixStartSlaveCmd;
    public final String suffixStartSlaveCmd;
    public final Integer launchTimeoutSeconds;
    public final Integer maxNumRetries;
    public final Integer retryWaitTime;

    public StandardUsernameCredentials getCredentials() {
        String credentialsId = this.credentialsId == null ? (this.credentials == null ? null : this.credentials.getId()) : this.credentialsId;
        try {
            StandardUsernameCredentials credentials;
            StandardUsernameCredentials standardUsernameCredentials = credentials = credentialsId == null ? null : SSHLauncher.lookupSystemCredentials(credentialsId);
            if (credentials != null) {
                this.credentials = credentials;
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.credentials == null && credentialsId == null) {
            this.credentials = SSHLauncher.upgrade(this.username, this.password, this.privatekey, null);
            this.credentialsId = this.credentials.getId();
        }
        return this.credentials;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundConstructor
    public SSHConnector(int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this(port, SSHLauncher.lookupSystemCredentials(credentialsId), null, null, null, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime);
    }

    @Deprecated
    public SSHConnector(int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds) {
        this(port, SSHLauncher.lookupSystemCredentials(credentialsId), null, null, null, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, null, null);
    }

    @Deprecated
    public SSHConnector(int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(port, SSHLauncher.lookupSystemCredentials(credentialsId), null, null, null, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
    }

    public SSHConnector(int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(port, credentials, null, null, null, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd);
    }

    public SSHConnector(int port, String username, String password, String privatekey, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(port, null, username, password, privatekey, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd);
    }

    public SSHConnector(int port, String username, String password, String privatekey, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(port, null, username, password, privatekey, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd);
    }

    public SSHConnector(int port, StandardUsernameCredentials credentials, String username, String password, String privatekey, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(port, credentials, username, password, privatekey, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
    }

    public SSHConnector(int port, StandardUsernameCredentials credentials, String username, String password, String privatekey, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this.jvmOptions = jvmOptions;
        this.port = port == 0 ? 22 : port;
        this.credentials = credentials;
        this.credentialsId = credentials == null ? null : this.credentials.getId();
        this.username = username;
        this.password = Secret.fromString((String)Util.fixEmpty((String)password));
        this.privatekey = privatekey;
        this.javaPath = javaPath;
        this.jdkInstaller = jdkInstaller;
        this.prefixStartSlaveCmd = Util.fixEmpty((String)prefixStartSlaveCmd);
        this.suffixStartSlaveCmd = Util.fixEmpty((String)suffixStartSlaveCmd);
        this.launchTimeoutSeconds = launchTimeoutSeconds == null || launchTimeoutSeconds <= 0 ? null : launchTimeoutSeconds;
        this.maxNumRetries = maxNumRetries != null && maxNumRetries > 0 ? maxNumRetries : 0;
        this.retryWaitTime = retryWaitTime != null && retryWaitTime > 0 ? retryWaitTime : 0;
    }

    public SSHLauncher launch(String host, TaskListener listener) throws IOException, InterruptedException {
        return new SSHLauncher(host, this.port, this.getCredentials(), this.jvmOptions, this.javaPath, this.jdkInstaller, this.prefixStartSlaveCmd, this.suffixStartSlaveCmd, this.launchTimeoutSeconds, this.maxNumRetries, this.retryWaitTime);
    }

    @Extension
    public static class DescriptorImpl
    extends ComputerConnectorDescriptor {
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (_context == null || !_context.hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME}));
        }

        public FormValidation doCheckLaunchTimeoutSeconds(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                if (Integer.parseInt(value.trim()) < 0) {
                    return FormValidation.error((String)Messages.SSHConnector_LaunchTimeoutMustBePostive());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.SSHConnector_LaunchTimeoutMustBeANumber());
            }
        }
    }
}

