/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.polling;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.AbstractIoAcceptor;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.ExpiringSessionRecycler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionRecycler;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.util.ExceptionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingConnectionlessIoAcceptor<S extends AbstractIoSession, H>
extends AbstractIoAcceptor {
    private static final IoSessionRecycler DEFAULT_RECYCLER = new ExpiringSessionRecycler();
    private static final long SELECT_TIMEOUT = 1000L;
    private final Semaphore lock = new Semaphore(1);
    private final IoProcessor<S> processor = new ConnectionlessAcceptorProcessor();
    private final Queue<AbstractIoAcceptor.AcceptorOperationFuture> registerQueue = new ConcurrentLinkedQueue<AbstractIoAcceptor.AcceptorOperationFuture>();
    private final Queue<AbstractIoAcceptor.AcceptorOperationFuture> cancelQueue = new ConcurrentLinkedQueue<AbstractIoAcceptor.AcceptorOperationFuture>();
    private final Queue<S> flushingSessions = new ConcurrentLinkedQueue<S>();
    private final Map<String, H> boundHandles = Collections.synchronizedMap(new HashMap());
    private IoSessionRecycler sessionRecycler = DEFAULT_RECYCLER;
    private final AbstractIoService.ServiceOperationFuture disposalFuture = new AbstractIoService.ServiceOperationFuture();
    private volatile boolean selectable;
    private Acceptor acceptor;
    private long lastIdleCheckTime;

    private String getAddressAsString(SocketAddress address) {
        InetAddress inetAddress = ((InetSocketAddress)address).getAddress();
        int port = ((InetSocketAddress)address).getPort();
        if (inetAddress == null) {
            return "null";
        }
        String result = null;
        if (inetAddress instanceof Inet4Address) {
            result = "/" + inetAddress.getHostAddress() + ":" + port;
        } else if (((Inet6Address)inetAddress).isIPv4CompatibleAddress()) {
            byte[] bytes = inetAddress.getAddress();
            result = "/" + bytes[12] + "." + bytes[13] + "." + bytes[14] + "." + bytes[15] + ":" + port;
        } else {
            result = inetAddress.toString();
        }
        return result;
    }

    protected AbstractPollingConnectionlessIoAcceptor(IoSessionConfig sessionConfig) {
        this(sessionConfig, null);
    }

    protected AbstractPollingConnectionlessIoAcceptor(IoSessionConfig sessionConfig, Executor executor) {
        super(sessionConfig, executor);
        try {
            this.init();
            this.selectable = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeIoException("Failed to initialize.", e);
        }
        finally {
            if (!this.selectable) {
                try {
                    this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    protected abstract void init() throws Exception;

    protected abstract void destroy() throws Exception;

    protected abstract int select() throws Exception;

    protected abstract int select(long var1) throws Exception;

    protected abstract void wakeup();

    protected abstract Iterator<H> selectedHandles();

    protected abstract H open(SocketAddress var1) throws Exception;

    protected abstract void close(H var1) throws Exception;

    protected abstract SocketAddress localAddress(H var1) throws Exception;

    protected abstract boolean isReadable(H var1);

    protected abstract boolean isWritable(H var1);

    protected abstract SocketAddress receive(H var1, IoBuffer var2) throws Exception;

    protected abstract int send(S var1, IoBuffer var2, SocketAddress var3) throws Exception;

    protected abstract S newSession(IoProcessor<S> var1, H var2, SocketAddress var3) throws Exception;

    protected abstract void setInterestedInWrite(S var1, boolean var2) throws Exception;

    @Override
    protected void dispose0() throws Exception {
        this.unbind();
        this.startupAcceptor();
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Set<SocketAddress> bindInternal(List<? extends SocketAddress> localAddresses) throws Exception {
        AbstractIoAcceptor.AcceptorOperationFuture request = new AbstractIoAcceptor.AcceptorOperationFuture(localAddresses);
        this.registerQueue.add(request);
        this.startupAcceptor();
        try {
            this.lock.acquire();
            Thread.sleep(10L);
            this.wakeup();
        }
        finally {
            this.lock.release();
        }
        request.awaitUninterruptibly();
        if (request.getException() != null) {
            throw request.getException();
        }
        HashSet<SocketAddress> newLocalAddresses = new HashSet<SocketAddress>();
        for (H handle : this.boundHandles.values()) {
            newLocalAddresses.add(this.localAddress(handle));
        }
        return newLocalAddresses;
    }

    @Override
    protected final void unbind0(List<? extends SocketAddress> localAddresses) throws Exception {
        AbstractIoAcceptor.AcceptorOperationFuture request = new AbstractIoAcceptor.AcceptorOperationFuture(localAddresses);
        this.cancelQueue.add(request);
        this.startupAcceptor();
        this.wakeup();
        request.awaitUninterruptibly();
        if (request.getException() != null) {
            throw request.getException();
        }
    }

    @Override
    public final IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (this.isDisposing()) {
            throw new IllegalStateException("Already disposed.");
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException("remoteAddress");
        }
        Object object = this.bindLock;
        synchronized (object) {
            if (!this.isActive()) {
                throw new IllegalStateException("Can't create a session from a unbound service.");
            }
            try {
                return this.newSessionWithoutLock(remoteAddress, localAddress);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to create a session.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoSession newSessionWithoutLock(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        IoSession session;
        IoSessionRecycler sessionRecycler;
        H handle = this.boundHandles.get(this.getAddressAsString(localAddress));
        if (handle == null) {
            throw new IllegalArgumentException("Unknown local address: " + localAddress);
        }
        IoSessionRecycler ioSessionRecycler = sessionRecycler = this.getSessionRecycler();
        synchronized (ioSessionRecycler) {
            session = sessionRecycler.recycle(localAddress, remoteAddress);
            if (session != null) {
                return session;
            }
            S newSession = this.newSession(this.processor, handle, remoteAddress);
            this.getSessionRecycler().put((IoSession)newSession);
            session = newSession;
        }
        this.initSession(session, null, null);
        try {
            this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            this.getListeners().fireSessionCreated(session);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
        return session;
    }

    public final IoSessionRecycler getSessionRecycler() {
        return this.sessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSessionRecycler(IoSessionRecycler sessionRecycler) {
        Object object = this.bindLock;
        synchronized (object) {
            if (this.isActive()) {
                throw new IllegalStateException("sessionRecycler can't be set while the acceptor is bound.");
            }
            if (sessionRecycler == null) {
                sessionRecycler = DEFAULT_RECYCLER;
            }
            this.sessionRecycler = sessionRecycler;
        }
    }

    private void startupAcceptor() throws InterruptedException {
        if (!this.selectable) {
            this.registerQueue.clear();
            this.cancelQueue.clear();
            this.flushingSessions.clear();
        }
        this.lock.acquire();
        if (this.acceptor == null) {
            this.acceptor = new Acceptor();
            this.executeWorker(this.acceptor);
        } else {
            this.lock.release();
        }
    }

    private boolean scheduleFlush(S session) {
        if (((AbstractIoSession)session).setScheduledForFlush(true)) {
            this.flushingSessions.add(session);
            return true;
        }
        return false;
    }

    private void processReadySessions(Iterator<H> handles) {
        while (handles.hasNext()) {
            H h = handles.next();
            handles.remove();
            try {
                if (this.isReadable(h)) {
                    this.readHandle(h);
                }
                if (!this.isWritable(h)) continue;
                for (IoSession session : this.getManagedSessions().values()) {
                    this.scheduleFlush((AbstractIoSession)session);
                }
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
            }
        }
    }

    private void readHandle(H handle) throws Exception {
        IoBuffer readBuf = IoBuffer.allocate(this.getSessionConfig().getReadBufferSize());
        SocketAddress remoteAddress = this.receive(handle, readBuf);
        if (remoteAddress != null) {
            IoSession session = this.newSessionWithoutLock(remoteAddress, this.localAddress(handle));
            readBuf.flip();
            IoBuffer newBuf = IoBuffer.allocate(readBuf.limit());
            newBuf.put(readBuf);
            newBuf.flip();
            session.getFilterChain().fireMessageReceived(newBuf);
        }
    }

    private void flushSessions(long currentTime) {
        AbstractIoSession session;
        while ((session = (AbstractIoSession)this.flushingSessions.poll()) != null) {
            session.unscheduledForFlush();
            try {
                boolean flushedAll = this.flush(session, currentTime);
                if (!flushedAll || session.getWriteRequestQueue().isEmpty(session) || session.isScheduledForFlush()) continue;
                this.scheduleFlush(session);
            }
            catch (Exception e) {
                session.getFilterChain().fireExceptionCaught(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(S session, long currentTime) throws Exception {
        this.setInterestedInWrite(session, false);
        WriteRequestQueue writeRequestQueue = ((AbstractIoSession)session).getWriteRequestQueue();
        int maxWrittenBytes = ((AbstractIoSession)session).getConfig().getMaxReadBufferSize() + (((AbstractIoSession)session).getConfig().getMaxReadBufferSize() >>> 1);
        int writtenBytes = 0;
        try {
            while (true) {
                int localWrittenBytes;
                IoBuffer buf;
                WriteRequest req;
                if ((req = ((AbstractIoSession)session).getCurrentWriteRequest()) == null) {
                    req = writeRequestQueue.poll((IoSession)session);
                    if (req == null) {
                        break;
                    }
                    ((AbstractIoSession)session).setCurrentWriteRequest(req);
                }
                if ((buf = (IoBuffer)req.getMessage()).remaining() == 0) {
                    ((AbstractIoSession)session).setCurrentWriteRequest(null);
                    buf.reset();
                    session.getFilterChain().fireMessageSent(req);
                    continue;
                }
                SocketAddress destination = req.getDestination();
                if (destination == null) {
                    destination = session.getRemoteAddress();
                }
                if ((localWrittenBytes = this.send(session, buf, destination)) == 0 || writtenBytes >= maxWrittenBytes) {
                    this.setInterestedInWrite(session, true);
                    boolean bl = false;
                    return bl;
                }
                this.setInterestedInWrite(session, false);
                ((AbstractIoSession)session).setCurrentWriteRequest(null);
                writtenBytes += localWrittenBytes;
                buf.reset();
                session.getFilterChain().fireMessageSent(req);
            }
        }
        finally {
            ((AbstractIoSession)session).increaseWrittenBytes(writtenBytes, currentTime);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerHandles() {
        AbstractIoAcceptor.AcceptorOperationFuture req;
        while ((req = this.registerQueue.poll()) != null) {
            HashMap<String, H> newHandles = new HashMap<String, H>();
            List<SocketAddress> localAddresses = req.getLocalAddresses();
            try {
                for (SocketAddress socketAddress : localAddresses) {
                    Object handle = this.open(socketAddress);
                    newHandles.put(this.getAddressAsString(this.localAddress(handle)), handle);
                }
                this.boundHandles.putAll(newHandles);
                this.getListeners().fireServiceActivated();
                req.setDone();
                int i$ = newHandles.size();
                return i$;
            }
            catch (Exception e) {
                req.setException(e);
            }
            finally {
                if (req.getException() == null) continue;
                for (SocketAddress handle : newHandles.values()) {
                    try {
                        this.close(handle);
                    }
                    catch (Exception e) {
                        ExceptionMonitor.getInstance().exceptionCaught(e);
                    }
                }
                this.wakeup();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unregisterHandles() {
        AbstractIoAcceptor.AcceptorOperationFuture request;
        int nHandles = 0;
        while ((request = this.cancelQueue.poll()) != null) {
            for (SocketAddress socketAddress : request.getLocalAddresses()) {
                H handle = this.boundHandles.remove(this.getAddressAsString(socketAddress));
                if (handle == null) continue;
                try {
                    this.close(handle);
                    this.wakeup();
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    ++nHandles;
                }
            }
            request.setDone();
        }
        return nHandles;
    }

    private void notifyIdleSessions(long currentTime) {
        if (currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            AbstractIoSession.notifyIdleness(this.getListeners().getManagedSessions().values().iterator(), currentTime);
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int nHandles = 0;
            AbstractPollingConnectionlessIoAcceptor.this.lastIdleCheckTime = System.currentTimeMillis();
            AbstractPollingConnectionlessIoAcceptor.this.lock.release();
            while (AbstractPollingConnectionlessIoAcceptor.this.selectable) {
                try {
                    int selected = AbstractPollingConnectionlessIoAcceptor.this.select(1000L);
                    if ((nHandles += AbstractPollingConnectionlessIoAcceptor.this.registerHandles()) == 0) {
                        try {
                            AbstractPollingConnectionlessIoAcceptor.this.lock.acquire();
                            if (AbstractPollingConnectionlessIoAcceptor.this.registerQueue.isEmpty() && AbstractPollingConnectionlessIoAcceptor.this.cancelQueue.isEmpty()) {
                                AbstractPollingConnectionlessIoAcceptor.this.acceptor = null;
                                break;
                            }
                        }
                        finally {
                            AbstractPollingConnectionlessIoAcceptor.this.lock.release();
                        }
                    }
                    if (selected > 0) {
                        AbstractPollingConnectionlessIoAcceptor.this.processReadySessions(AbstractPollingConnectionlessIoAcceptor.this.selectedHandles());
                    }
                    long currentTime = System.currentTimeMillis();
                    AbstractPollingConnectionlessIoAcceptor.this.flushSessions(currentTime);
                    nHandles -= AbstractPollingConnectionlessIoAcceptor.this.unregisterHandles();
                    AbstractPollingConnectionlessIoAcceptor.this.notifyIdleSessions(currentTime);
                }
                catch (ClosedSelectorException cse) {
                    break;
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (AbstractPollingConnectionlessIoAcceptor.this.selectable && AbstractPollingConnectionlessIoAcceptor.this.isDisposing()) {
                AbstractPollingConnectionlessIoAcceptor.this.selectable = false;
                try {
                    AbstractPollingConnectionlessIoAcceptor.this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    AbstractPollingConnectionlessIoAcceptor.this.disposalFuture.setValue(true);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionlessAcceptorProcessor
    implements IoProcessor<S> {
        private ConnectionlessAcceptorProcessor() {
        }

        @Override
        public void add(S session) {
        }

        @Override
        public void flush(S session) {
            if (AbstractPollingConnectionlessIoAcceptor.this.scheduleFlush(session)) {
                AbstractPollingConnectionlessIoAcceptor.this.wakeup();
            }
        }

        @Override
        public void remove(S session) {
            AbstractPollingConnectionlessIoAcceptor.this.getSessionRecycler().remove((IoSession)session);
            AbstractPollingConnectionlessIoAcceptor.this.getListeners().fireSessionDestroyed((IoSession)session);
        }

        @Override
        public void updateTrafficControl(S session) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public boolean isDisposing() {
            return false;
        }
    }
}

