/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;
import org.jenkinsci.plugins.workflow.support.steps.stage.Messages;

public class StageStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(StageStepExecution.class.getName());
    @Inject(optional=true)
    private transient StageStep step;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient FlowNode node;
    private static Map<String, Map<String, Stage>> stagesByNameByJob;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        if (this.getContext().hasBody()) {
            if (this.step.concurrency != null) {
                throw new AbortException(Messages.StageStepExecution_concurrency_not_supported_in_block_mode());
            }
            this.getContext().newBodyInvoker().withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).withDisplayName(this.step.name).start();
            return false;
        }
        ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println(Messages.StageStepExecution_non_block_mode_deprecated());
        if (StageStepExecution.isInsideParallel(this.node)) {
            throw new AbortException(Messages.StageStepExecution_the_stage_step_must_not_be_used_inside_a());
        }
        this.node.addAction((Action)new LabelAction(this.step.name));
        this.node.addAction((Action)new StageActionImpl(this.step.name));
        StageStepExecution.enter(this.run, this.getContext(), this.step.name, this.step.concurrency);
        return false;
    }

    private static boolean isInsideParallel(FlowNode n) {
        while (true) {
            if (n instanceof BlockEndNode) {
                n = ((BlockEndNode)n).getStartNode();
            }
            if (n.getAction(ThreadNameAction.class) != null) {
                return true;
            }
            List parents = n.getParents();
            if (parents.isEmpty()) {
                assert (n instanceof FlowStartNode);
                return false;
            }
            assert (parents.size() == 1);
            n = (FlowNode)parents.get(0);
        }
    }

    public void stop(Throwable cause) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static XmlFile getConfigFile() throws IOException {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IOException("Jenkins is not running");
        }
        return new XmlFile(new File(j.getRootDir(), StageStep.class.getName() + ".xml"));
    }

    public static void clear() {
        stagesByNameByJob = null;
    }

    private static synchronized void load() {
        if (stagesByNameByJob == null) {
            stagesByNameByJob = new TreeMap<String, Map<String, Stage>>();
            try {
                XmlFile configFile = StageStepExecution.getConfigFile();
                if (configFile.exists()) {
                    stagesByNameByJob = (Map)configFile.read();
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            LOGGER.log(Level.FINE, "load: {0}", stagesByNameByJob);
        }
    }

    private static synchronized void save() {
        try {
            StageStepExecution.getConfigFile().write(stagesByNameByJob);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        LOGGER.log(Level.FINE, "save: {0}", stagesByNameByJob);
    }

    private static synchronized void enter(Run<?, ?> r, StepContext context, String name, Integer concurrency) {
        Stage stage;
        LOGGER.log(Level.FINE, "enter {0} {1}", new Object[]{r, name});
        StageStepExecution.println(context, "Entering stage " + name);
        StageStepExecution.load();
        Job job = r.getParent();
        String jobName = job.getFullName();
        Map<String, Stage> stagesByName = stagesByNameByJob.get(jobName);
        if (stagesByName == null) {
            stagesByName = new TreeMap<String, Stage>();
            stagesByNameByJob.put(jobName, stagesByName);
        }
        if ((stage = stagesByName.get(name)) == null) {
            stage = new Stage();
            stagesByName.put(name, stage);
        }
        stage.concurrency = concurrency;
        int build = r.number;
        if (stage.waitingContext != null) {
            if (stage.waitingBuild < build) {
                try {
                    StageStepExecution.cancel(stage.waitingContext, context);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "could not cancel an older flow (perhaps since deleted?)", x);
                }
            } else if (stage.waitingBuild > build) {
                try {
                    StageStepExecution.cancel(context, stage.waitingContext);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "could not cancel the current flow", x);
                }
                build = stage.waitingBuild;
                context = stage.waitingContext;
            } else {
                throw new IllegalStateException("the same flow is trying to re\u00ebnter the stage " + name);
            }
        }
        for (Map.Entry<String, Stage> entry : stagesByName.entrySet()) {
            if (entry.getKey().equals(name)) continue;
            Stage stage2 = entry.getValue();
            if (!stage2.holding.remove(build) || stage2.waitingContext == null) continue;
            stage2.unblock("Unblocked since " + r.getDisplayName() + " is moving into stage " + name);
        }
        stage.waitingBuild = build;
        stage.waitingContext = context;
        if (stage.concurrency == null || stage.holding.size() < stage.concurrency) {
            stage.unblock("Proceeding");
        } else {
            StageStepExecution.println(context, "Waiting for builds " + stage.holding);
        }
        StageStepExecution.cleanUp(job, jobName);
        StageStepExecution.save();
    }

    private static synchronized void exit(Run<?, ?> r) {
        StageStepExecution.load();
        LOGGER.log(Level.FINE, "exit {0}: {1}", new Object[]{r, stagesByNameByJob});
        Job job = r.getParent();
        String jobName = job.getFullName();
        Map<String, Stage> stagesByName = stagesByNameByJob.get(jobName);
        if (stagesByName == null) {
            return;
        }
        boolean modified = false;
        for (Stage stage : stagesByName.values()) {
            if (!stage.holding.contains(r.number)) continue;
            stage.holding.remove(r.number);
            modified = true;
            if (stage.waitingContext == null) continue;
            stage.unblock("Unblocked since " + r.getDisplayName() + " finished");
        }
        if (modified) {
            StageStepExecution.cleanUp(job, jobName);
            StageStepExecution.save();
        }
    }

    private static void cleanUp(Job<?, ?> job, String jobName) {
        Map<String, Stage> stagesByName = stagesByNameByJob.get(jobName);
        assert (stagesByName != null);
        Iterator<Map.Entry<String, Stage>> it = stagesByName.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Stage> entry = it.next();
            Set<Integer> holding = entry.getValue().holding;
            Iterator<Integer> it2 = holding.iterator();
            while (it2.hasNext()) {
                Integer number = it2.next();
                if (job.getBuildByNumber(number.intValue()) != null) continue;
                LOGGER.log(Level.WARNING, "Cleaning up apparently deleted {0}#{1}", new Object[]{jobName, number});
                it2.remove();
            }
            if (!holding.isEmpty()) continue;
            assert (entry.getValue().waitingContext == null) : entry;
            it.remove();
        }
        if (stagesByName.isEmpty()) {
            stagesByNameByJob.remove(jobName);
        }
    }

    private static void println(StepContext context, String message) {
        if (!context.isReady()) {
            LOGGER.log(Level.FINE, "cannot print message \u2018{0}\u2019 to dead {1}", new Object[]{message, context});
            return;
        }
        try {
            ((TaskListener)context.get(TaskListener.class)).getLogger().println(message);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "failed to print message to dead " + context, x);
        }
    }

    private static void cancel(StepContext context, StepContext newer) throws IOException, InterruptedException {
        if (context.isReady() && newer.isReady()) {
            StageStepExecution.println(context, "Canceled since " + ((Run)newer.get(Run.class)).getDisplayName() + " got here");
            StageStepExecution.println(newer, "Canceling older " + ((Run)context.get(Run.class)).getDisplayName());
            context.onFailure((Throwable)new FlowInterruptedException(Result.NOT_BUILT, new CauseOfInterruption[]{new CanceledCause((Run)newer.get(Run.class))}));
        } else {
            LOGGER.log(Level.WARNING, "cannot cancel dead {0} or {1}", new Object[]{context, newer});
        }
    }

    @Extension
    public static final class Listener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> r, TaskListener listener) {
            if (!(r instanceof FlowExecutionOwner.Executable) || ((FlowExecutionOwner.Executable)r).asFlowExecutionOwner() == null) {
                return;
            }
            StageStepExecution.exit(r);
        }
    }

    private static final class Stage {
        final Set<Integer> holding = new TreeSet<Integer>();
        @CheckForNull
        Integer concurrency;
        @CheckForNull
        StepContext waitingContext;
        @Nullable
        Integer waitingBuild;

        private Stage() {
        }

        public String toString() {
            return "Stage[holding=" + this.holding + ",waitingBuild=" + this.waitingBuild + ",concurrency=" + this.concurrency + "]";
        }

        void unblock(String message) {
            assert (Thread.holdsLock(StageStepExecution.class));
            assert (this.waitingContext != null) : message;
            assert (this.waitingBuild != null) : message;
            if (this.holding.contains(this.waitingBuild)) {
                LOGGER.log(Level.WARNING, "{0}: {1} already in {2}", new Object[]{message, this.waitingBuild, this.holding});
            }
            StageStepExecution.println(this.waitingContext, message);
            this.waitingContext.onSuccess(null);
            this.holding.add(this.waitingBuild);
            this.waitingContext = null;
            this.waitingBuild = null;
        }
    }

    public static final class CanceledCause
    extends CauseOfInterruption {
        private static final long serialVersionUID = 1L;
        private final String newerBuild;

        CanceledCause(Run<?, ?> newerBuild) {
            this.newerBuild = newerBuild.getExternalizableId();
        }

        public Run<?, ?> getNewerBuild() {
            return Run.fromExternalizableId((String)this.newerBuild);
        }

        public String getShortDescription() {
            return "Superseded by " + this.getNewerBuild().getDisplayName();
        }
    }

    private static final class StageActionImpl
    extends InvisibleAction
    implements StageAction {
        private final String stageName;

        StageActionImpl(String stageName) {
            this.stageName = stageName;
        }

        public String getStageName() {
            return this.stageName;
        }
    }
}

